function ref = wfu_paradigm_lookup(refnum)

%   Finds reference function that corresponds to a particular
%   paradigm number
%   FORMAT ref = wfu_paradigm_lookup(refnum)
%
%   ref       - filename of reference function 
%   refnum    - paradigm number 
%_____________________________________________________________

table   = '';
pth     = fullfile(getenv('WFU_PATH'),'global.site.ksh');
if isempty(pth)
    error(sprintf('WFU_PATH undefined for user: %s, check global.site.ksh file',getenv('USER'))); 
else
    sitefid = fopen(pth,'rt');
    while 1
        line = fgetl(sitefid);
        if ~ischar(line)
            break
        end
        if ~isempty(line) & ~strcmp('#',line(1))
            delimiter   = min(find(line=='='));
            field       = deblank(line(1:delimiter-1)); 
            value       = deblank(line(delimiter+1:end));
            if strcmp('refdir',field) & isstr(value) 
                table = fullfile(value,'paradigm_lookup_table'); 
            end
        end
    end
    sitefid = fclose(sitefid);
end    
        
if isempty(table)
    table = '/fmri2/fmri/ref_functions/paradigm_lookup_table';
end
refnum  = num2str(refnum);
ref     = '';

fid = fopen(table,'rt');
while 1
    line = fgetl(fid);
    if ~ischar(line)
        break
    end
    if ~isempty(line) & ~strcmp(';',line(1))
        firstSpace  = min(find(isspace(line)));
        if firstSpace > 2
            lookupNum   = line(1:firstSpace-1);
        else
            lookupNum   = line(1);
        end
        if strcmp(refnum,lookupNum)
            lineEnd = line(firstSpace:end); 
            ref     = lineEnd(~isspace(lineEnd));
        end
    end
end

if isempty(ref)
    warning(sprintf('Reference number (%s) was not found in lookup table:\n''%s''',refnum,table));
end

fid = fclose(fid);
return