function reftext = wfu_permute_contrasts(reftext)


for i = 1:length(reftext)

    if iscell(reftext), text_var = reftext{i}; 
    else, text_var = reftext; 
    end

    %----- Only use time and dispersion if there are events -----%
event_pass = 0;
combined_paradigm_flag = 0;
if isfield(text_var,'combined_paradigms'), event_pass = 1; combined_paradigm_flag = 1; end
if isfield(text_var,'events'), event_pass = 1; end; 
    if (event_pass && isfield(text_var,'time_derivative') && text_var.time_derivative == 1)
        dispersion_pass = 1;
        text_var.model.fmri_spec.bases.hrf.derivs = [1 0]; % time derivative
        if isfield(text_var,'dispersion_derivative') & text_var.dispersion_derivative == 1
            text_var.model.fmri_spec.bases.hrf.derivs(2) = 1; % set dispersion derivative
            if ~isfield(text_var,'dispersion_derivative_weight')
                dispersion_pass = 0;
                error('Weight must be specified in reference function if DISPERSION DERIVATIVE is selected.');
            end
        end
        if isfield(text_var,'time_derivative_weight') & dispersion_pass
            if ~combined_paradigm_flag, text_var = local_deriv_mods(text_var,'time'); end
	    if combined_paradigm_flag, text_var = local_fe_deriv_mods(text_var,'time'); end
        else
            error('Weight must be specified in reference function if TIME DERIVATIVE is selected.');
        end
    end
    if (isfield(text_var,'model_realignment') && text_var.model_realignment == 1)
        %pad = cellstr(num2str([0 0 0 0 0 0]'))';
        pad = num2str(zeros(1,6)');
        for c = 1:length(text_var.contrast_types)
            for j = 1:6
                text_var.contrast_values{c}{end+1} = char(pad(j));
            end
        end
    end
    
    %----------- Block effects ------------%
	block_its = 1;
	if combined_paradigm_flag,
        %This next line seems like an error
        %I think the block effects for fixed effects ref functions should
        %be the number of combined paradigms
		%block_its = length(text_var.global_alternate_id);
        block_its = length(text_var.combined_paradigms);
	end
		
        for c = 1:length(text_var.contrast_types)
            for j = 1:block_its, text_var.contrast_values{c}{end+1} = '0'; end
        end
   
    if iscell(reftext), reftext{i} = text_var; 
    else, reftext = text_var; 
    end

end
return


%_______________________________________________________________
function new = local_deriv_mods(new,type)
% Adds a column to contrast (one for each ?) for time/dispersion
% derivatives
new.contrast_values = new.native_contrast_values;
newweights          = [];

for c = 1:length(new.contrast_types)
    currentrun = 1;
    nweights        = length(new.contrast_values{c});
    newweights{c}   = [];
    time_weights=cell(1,nweights);
    dispersion_weights = time_weights;
    td_weights = cellstr(num2str(new.time_derivative_weight'))';
    if new.time_derivative_weight == 1; td_weights = new.contrast_values{c}; end
    time_weights(:) = td_weights;
    if new.dispersion_derivative == 1
        dd_weights = cellstr(num2str(new.dispersion_derivative_weight'))';
        if new.dispersion_derivative_weight == 1; dd_weights = new.contrast_values{c}; end
        dispersion_weights(:) = dd_weights;
    end
    for i = 1:nweights
        newweights{c}{end+1} = new.contrast_values{c}{i};
        %only use time and dispersion on conditions that are events
	if find(new.events.num == i), 
            if new.time_derivative == 1; newweights{c}{end+1} = char(time_weights(i)); end
            if new.dispersion_derivative == 1; newweights{c}{end+1} = char(dispersion_weights(i)); end
        end
    end
    new.contrast_values{c} = newweights{c};
end

%%%%---------------------------------------------
%%%%---------------------------------------------

function new = local_fe_deriv_mods(new,type)
% Adds a column to contrast (one for each ?) for time/dispersion
% derivatives
new.contrast_values = new.native_contrast_values;
newweights          = [];
index = 0; 
event_struc = [];
if new.global_alternate_id(1) > 0
    for i = 1:length(new.global_alternate_id)
    	rx = wfu_read_refs(wfu_paradigm_lookup(new.global_alternate_id(i)));
    	event_struc = [event_struc ((rx{1}.events.num) + index) ];
    	index = index + rx{1}.conditions;
    end
end
new.events.num = event_struc;	

for c = 1:length(new.contrast_types)
    currentrun = 1;
    nweights        = length(new.contrast_values{c});
    newweights{c}   = [];
    time_weights=cell(1,nweights);
    dispersion_weights = time_weights;
    td_weights = cellstr(num2str(new.time_derivative_weight'))';
    if new.time_derivative_weight == 1; td_weights = new.contrast_values{c}; end
    time_weights(:) = td_weights;
    if new.dispersion_derivative == 1
        dd_weights = cellstr(num2str(new.dispersion_derivative_weight'))';
        if new.dispersion_derivative_weight == 1; dd_weights = new.contrast_values{c}; end
        dispersion_weights(:) = dd_weights;
    end
    for i = 1:nweights
        newweights{c}{end+1} = new.contrast_values{c}{i};
	%only use time and dispersion on conditions that are events
       	if find(new.events.num == i),
            if new.time_derivative == 1; newweights{c}{end+1} = char(time_weights(i)); end
            if new.dispersion_derivative == 1; newweights{c}{end+1} = char(dispersion_weights(i)); end
        end
    end
    new.contrast_values{c} = newweights{c};
end
