function [priority] = wfu_priority(bchdir,user,groups)
%---------------------------------------------
%Determines priority level for grid processes
%priority file is dropped in each batch folder if provided
%---------------------------------------------



priority = 0;

non_lab = 0;
ansir_lab = 1;
clinical = 5;
su = 10;

g(1).name = 'clinical';
g(1).priority = clinical;
g(2).name = 'usrfmri';
g(2).priority = ansir_lab;


u(1).name = ['maldjian'];
u(1).priority = su;

if ~exist('bchdir','var'), bchdir = [];  end
if ~exist('user','var'), user = [];  end
if ~exist('groups','var'), groups = [];  end

if isempty(user), [a, user] = unix('whoami'); end
if isempty(groups), [b,groups] = unix('groups'); end


%match priority based on group
for i = 1:length(g)
	if strfind(groups,g(i).name), priority = max(priority,g(i).priority); end;
end

%match priority based on user
for i = 1:length(u)
	if strfind(user,u(i).name), priority = max(priority,u(i).priority); end;
end

if ~isempty(bchdir)
	ufname = fullfile(bchdir, 'priority');
	ufid = fopen(ufname,'wt');
	if ufid==-1 
 	   error(sprintf('priority-file %s\n\tcould not be opened for writing',ufname));
	    return; 
	end
	fprintf(ufid, '%s \n',num2str(priority));
	%----- Close xfile -----%
	status = fclose(ufid);
	if status~=0 
   	 error(sprintf('priority %s\n\tcould not be closed after writing',matname));
	else
    	success = 1; 
	end

end
