function number = wfu_randnum(smallest,largest)

%   Generate pseudo-random numbers within specified range
%   FORMAT number = wfu_randnum(smallest,largest)
%   
%   number      - pseudo random number
%   smallest    - smallest possible value of random number
%   largest     - largest possible value of random number 
%  
%   NOTE: wfu_randnum first creates a list of random values 
%         and then indexes that list with a randomly generated
%         value to obtain a "more random" number.
%______________________________________________________________


if nargin < 1 
    smallest = 1; 
end

if nargin < 2 
    largest = 10000; 
end

randoms = ceil(rand(10000,1)*(largest-smallest));
seed    = mod(round(cputime*100),(largest-smallest+1))+smallest;
number  = randoms(seed); 