function vars = wfu_read_info(filename)

% Loads tab-delimited matlab file
% FORMAT varStruct = wfu_read_info(filename)
%
% varStruct     - structure containing variables and values
% filename      - any tab-delimited matlab file  
%                 Comments must use matlab convention (%) 
%___________________________________________________________

vars        = [];
[p,n,ext,v] = fileparts(filename); 

if strcmp(ext,'.xls')
    [numeric,text,raw] = xlsread(filename);
    [nrows,ncolumns] = size(raw); 
    for i = 1:nrows
        vars = setfield(vars,raw{i},raw{i+nrows});
    end        
elseif strcmp(ext,'.txt') | strcmp(ext,'.info') | isempty(ext) 
    [variable,value] = textread(filename,'%s %s', ...
        'headerlines',  0, ...
        'commentstyle', 'matlab' ...
        );
    for i = 1:length(value)
        numValue = str2num(value{i});
        if ~isempty(numValue)
            value{i} = numValue;
        end
        vars = setfield(vars,char(variable{i}),value{i}); 
    end
else
    error(sprintf('Unknown file type\nMust be .info, .txt or .xls'));
end
return