function [mainjobs,wfujob,DIR] = wfu_ref2job(DIR,wfujob)
   
%   Use reference function parameters to generate a job 
%   structure for spm_jobman
%
%   FORMAT [mainjobs,wfujob,DIR] = wfu_ref2job(DIR,wfujob)
%
% Input variables:
%   wfujob      - structure containing user defined job 
%                 parameters (via GUI or wfu_defaults.m) 
%   DIR         - structure containing full paths of all 
%                 subject subdirectories and standard
%                 filenames
%
% Output variables: 
%   mainjobs    - job structure for use with spm_jobman.m 
%   wfujob      - same as above, but with addition of a 
%                 wfujob.finalimgs field
%   DIR         - same as above, but with addition of a .spms
%                 field
%____________________________________________________________
%global defaults; spm_defaults; %wfu_defaults;

defaults        = wfu_defaults(wfujob); 
allepis=[]; allepiscell=[];
normcount=1; spatcount=1; statcount=1;
spatial         = {}; 
stats           = {}; 
[junk,prefix]   = fileparts(DIR.subject); 
nruns           = DIR.nruns;

for r = 1:nruns
    next_epi = wfujob.epis{r};
    [a,prefix,c] = fileparts(next_epi);
    %allepiscell{r} = wfu_select(DIR.norm{r},['^',prefix(1:3),'.*'],'extimage',1);
    allepiscell{r} = wfu_select(DIR.norm{r},['^',prefix(1:3),'.*'],'extimage',1);
    allepis = [allepis;allepiscell{r}]; 
end


%% only one for each run, first run is different            %%
%% no images are written, so no prefix change is necessary  %%
if wfujob.realign.enabled
    for r = 1:nruns
        if r == 1
            data{1} = allepiscell{r}; 
        else
            data{1} = allepiscell{1}(1); 
            data{2} = allepiscell{r};
        end        
        spatial{spatcount}.realign{r}.estimate.data = data;
        eoptions = defaults.realign.estimate;
        if isnumeric(eoptions.weight)
            eoptions.weight = {};
        end
        spatial{1}.realign{r}.estimate.eoptions = eoptions;
    end
    spatcount = spatcount + 1;
end


if wfujob.normalise.anat.enabled
    %% done once to produce '*_sn.mat', kept in the anatomic directory %%
    roptions                = defaults.normalise.write;
    eoptions                = defaults.normalise.estimate;
    %eoptions.template{1}    = fullfile(spm('dir'),'templates','T1.nii');
    eoptions.template{1}    = defaults.normalise.estimate.mniT1;
    
    if isempty(eoptions.weight)
        eoptions.weight = {''};
        subj.wtsrc      = {};
    end
    subjectT1       = wfu_pick_template(DIR.analyze);
    subj.source{1}  = subjectT1; 
    if isempty(subj.source{1})
        error('Source image could not be found for T1-->T1 shadow transform normalization. Aborting.'); 
    end
    [spms_p,spms_b,spms_ext] = fileparts(char(subjectT1));
    DIR.spms = fullfile(spms_p,['w' spms_b spms_ext]);

    subj.resample{1} = subj.source{1}; 
    spatial{spatcount}.anat.normalise{1}.estwrite.subj       = subj;
    spatial{spatcount}.anat.normalise{1}.estwrite.eoptions   = eoptions;
    spatial{spatcount}.anat.normalise{1}.estwrite.roptions   = roptions;
    spatcount = spatcount + 1;
	if wfujob.normalise.shadow.enabled   
	    %% write parameters to epi in each run seperately %%
	    for r = 1:nruns
	        subj            = [];
	        roptions        = defaults.normalise.write;
	        [path,name]     = fileparts(subjectT1); 
 	        subj.matname{1} = fullfile(path,[name,'_sn.mat']);
	        subj.resample   = allepiscell{r};
 	        spatial{spatcount}.shadow_normalise{r}.write.roptions  = roptions;
 	        spatial{spatcount}.shadow_normalise{r}.write.subj      = subj;
 	   end
 	   allepiscell = wfu_prepend(allepiscell,'w','cell');
 	   allepis     = wfu_prepend(allepis,'w','list');
	   spatcount = spatcount + 1;
	end
end

if wfujob.normalise.epi.enabled
    subj                    = [];
    eoptions                = defaults.normalise.estimate; 
    %eoptions.template{1}    = fullfile(spm('dir'),'templates','EPI.nii');
    eoptions.template{1}    = defaults.normalise.estimate.mniEPI;
    
    if isempty(eoptions.weight)
        eoptions.weight = {''};
        subj.wtsrc      = {}; 
    end
    roptions = defaults.normalise.write;
    for r = 1:nruns
	next_ref = wfujob.refs{r};
	if isfield(next_ref,'vox')
		voxsize = next_ref.vox;
	else 
		voxsize = wfu_voxsize(wfujob.epis{r});
	end;
	roptions.vox = voxsize;
	if isfield(next_ref,'bb'), roptions.bb = bb; end;
        subj.resample   = allepiscell{r};
        subj.source{1}  = subj.resample{1};
        if isempty(find(subj.source{1}==','))
            subj.source{1} = [subj.source{1},',1']; 
        end
        spatial{spatcount}.normalise{r}.estwrite.subj       = subj;
        spatial{spatcount}.normalise{r}.estwrite.roptions   = roptions;
        spatial{spatcount}.normalise{r}.estwrite.eoptions   = eoptions;
    end
    allepiscell = wfu_prepend(allepiscell,'w','cell');
    allepis     = wfu_prepend(allepis,'w','list');
    spatcount   = spatcount + 1;
end

%% each run smoothing needs to be in its own 'spatial' cell %% 
if wfujob.smooth.enabled
    opts = spm_config_smooth; 
    fwhm = opts.val{2}.val{1};
    for r = 1:nruns
        spatial{spatcount}.smooth{r}.fwhm = fwhm;
        spatial{spatcount}.smooth{r}.data = allepiscell{r};
    end
    allepiscell = wfu_prepend(allepiscell,'s','cell');
    allepis     = wfu_prepend(allepis,'s','list');
    spatcount   = spatcount + 1;
end

if wfujob.model.enabled
    for r = 1:nruns
        %--- specification ---% 
	consess = [];
        fmri_spec               = wfujob.model.fmri_spec;
        fmri_spec.sess(1).scans = allepiscell{r};
        for c = 1:wfujob.refs{r}.conditions
            fmri_spec.sess(1).cond(c)           = fmri_spec.sess(1).cond(1);
            fmri_spec.sess(1).cond(c).name      = wfujob.refs{r}.names{c}; 
            fmri_spec.sess(1).cond(c).onset     = wfujob.refs{r}.SPMons{c}';
            fmri_spec.sess(1).cond(c).duration  = wfujob.refs{r}.SPMdur{c}'; 
        end
        fmri_spec.timing.RT         = wfujob.refs{r}.tr; 
        fmri_spec.dir{1}            = DIR.spm{r};
        try fmri_spec.bases         = wfujob.refs{r}.model.fmri_spec.bases;
        catch fmri_spec.bases       = wfujob.model.fmri_spec.bases; 
        end
        stats{statcount}.fmri_spec  = fmri_spec;
        statcount                   = statcount + 1;


        %--- estimation ---% 
        fmri_est                    = wfujob.model.fmri_est;
        fmri_est.dir{1}             = DIR.spm{r}; 
        fmri_est.spmmat{1}          = DIR.F.spmmat{r};
        stats{statcount}.fmri_est   = fmri_est; 
        statcount                   = statcount + 1;

        %--- contrasts ---%
        for c = 1:length(wfujob.refs{r}.contrast_names)
            con = [];
            switch wfujob.refs{r}.contrast_types{c}
                case 'T'
                    for i = 1:length(wfujob.refs{r}.contrast_values{c}) 
                        weight = wfujob.refs{r}.contrast_values{c}{i};
                        if isempty(con), blank = ''; else blank = ' '; end 
                        con = [con,blank,weight];
                    end
                    consess{c}.tcon.convec  = con; 
                    consess{c}.tcon.name    = wfujob.refs{r}.contrast_names{c}; 
                    
                case 'F'
                    for i = 1:length(wfujob.refs{r}.contrast_values{c}) 
                        weight = wfujob.refs{r}.contrast_values{c}{i};
                        if isempty(con), blank = ''; else blank = ' '; end 
                        con = [con,blank,weight];
                    end
                    consess{c}.fcon.convec  = {con}; 
                    consess{c}.fcon.name    = wfujob.refs{r}.contrast_names{c};   
            end
        end
        stats{statcount}.con.spmmat{1} = DIR.F.spmmat{r};
        stats{statcount}.con.consess = consess;
        statcount = statcount + 1; 
    end
end

if ~isempty(spatial) 
    mainjobs{1}.spatial = spatial;
end
if ~isempty(stats)
    mainjobs{1}.stats = stats;
end
wfujob.finalimgs = allepiscell; 
