function reply = wfu_rsh_server(filename)
%--------------------------------
%This program will find the
%unix server mountpoint
%For rsh commands with File I/O
%--------------------------------

[fp,fn,fext] = fileparts(filename);
[a,b] = unix(['df -k ' fp ' | grep :']);
mount=strtok(b(end:-1:1));
mount = mount(end:-1:1);
[server,directory] = strtok(strtok(b),':');
rsh_directory = directory(2:end);
reply.index = length(mount) + 1;
reply.rsh_file = fullfile(rsh_directory,filename(reply.index:end));
[a,hostname] = unix('hostname');
reply.server = server;
reply.rsh_path = rsh_directory;
reply.filename = filename;
reply.rsh = 1;
reply.error = 0;
if strcmp(hostname,server), reply.rsh = 0; end
if length(server) < 2, reply.error = 1; end
if length(strfind(b,':')) > 1, reply.error = 1; end
if reply.error
	sprintf('unable to find mount for rsh in wfu_rsh_server');
	reply.rsh = 0;
end
