function [anatulist,ulist,fixulist] = wfu_scriptmaker( ...
    mainjobs,fixjobs,DIR,wfujob,runvector,anatflag,fixedflag)

% FORMAT [anatulist,ulist,fixulist] = wfu_scriptmaker( ...
%   mainjobs,fixjobs,DIR,wfujob,runvector,anatflag,fixedflag)
%
% anatulist -
% ulist     -
% fixulist  -
%
% mainjobs  -
% fixjobs   -
% DIR       -
% wfujob    -
% runvector -
% anatflag  -
% fixedflag -
%___________________________________________________________


cleanup         = 1;                        %u-file cleanup (rsh)
[junk,subject]  = fileparts(DIR.subject);
smrun           = 1;
xStatus         = [];
uStatus         = [];
nruns           = DIR.nruns;
matlist         = [];
xlist           = [];
ulist           = [];
fixulist        = [];
anatulist     	= [];



if ~exist('anatflag'),  anatflag = 1; end
if ~exist('fixedflag'), fixedflag = 1; end

if ~exist('runvector')
    runvector = [];
    for i = 1:nruns
        runvector = [runvector,i];
    end
end

for r = runvector,      ulist{r} = []; end

for j = 1:length(mainjobs) %- currently, multiple jobs are only used for fixed effects
    if j == 1
        if isfield(mainjobs{j},'spatial')
            for s = 1:length(mainjobs{j}.spatial)
                jobs 	= [];
                field   = fieldnames(mainjobs{j}.spatial{s});
                
                if length(field) > 1
                    error(sprintf('Length of fields in mainjobs{%i}.spatial{%s} is greater than one',j,s));
                end

                switch field{1}
                    case 'realign'
                        tasktype = 'realignment';
                        for r = runvector
                            %--- write MAT-file ---%
                            jobs{1}.spatial{1}.realign{1} = mainjobs{j}.spatial{s}.realign{r};
                            wfu_save(DIR.F.matname{r}.realign,jobs,'jobs');
                            matlist{end+1} = DIR.F.matname{r}.realign;
                            %--- write X-file ---%
                            [xStatus(end+1),xfid] = wfu_X_scriptwrite( ...
                                DIR.F.xname{r}.realign,...
                                DIR.F.matname{r}.realign,...
                                DIR.F.uname{r}.realign, ...
                                DIR.bchrun{r},DIR.matcode,...
                                DIR.spmxdir,...
                                DIR.oldmatcode,...
                                tasktype);
                            xlist{end+1} = DIR.F.xname{r}.realign;
                            %--- write U-file ---%
                            [uStatus(end+1),ufid] = wfu_U_scriptwrite( ...
                                DIR.F.uname{r}.realign,...
                                DIR.F.logfile{r},...
                                DIR.bchrun{r},...
                                tasktype, ...
                                DIR.norm{r},...
                                cleanup,...
                                subject,...
                                DIR.F.unixout{r},...
                                DIR.F.xname{r}.realign, ...
                                DIR.F.launchscript,...
                                DIR.F.cpufinder,...
                                DIR.F.cpuout{r},...
                                'nocompfile',...
                                DIR.subject,...
                                DIR.F.matout{r},...
                                wfujob.data{r});
                            ulist{r}{end+1} = DIR.F.uname{r}.realign;
                        end % for r = runvector

                    case 'anat'
                        if anatflag
                            tasktype = 'shadow_normalization_T1';
                            % High resolution anatomical (T1) image is normalized 
                            % to the T1 template (T1.nii) but not written.
                            % A *_sn.mat is created with those estimation parameters. This
                            % estimation takes place only once in the batch/anatomic directory
                            
                            for n = 1:length(mainjobs{j}.spatial{s}.anat.normalise)
                                task = mainjobs{j}.spatial{s}.anat.normalise{n};
                                jobs{1}.spatial{1}.normalise{1} = task;
                                [spms_p,spms_b,spms_ext] = fileparts(char(task.estwrite.subj.source));
                                spms = fullfile(spms_p,['w' spms_b spms_ext]);
                                
                                %--- MAT-file ---%
                                wfu_save(DIR.F.anat.matname{1}.shadowT1,jobs,'jobs');
                                matlist{end+1} = DIR.F.anat.matname{1}.shadowT1;
                                %--- X-file ---%
                                [xStatus(end+1),xfid] = wfu_X_scriptwrite( ...
                                    DIR.F.anat.xname{1}.shadowT1,...
                                    DIR.F.anat.matname{1}.shadowT1,...
                                    DIR.F.anat.uname{1}.shadowT1, ...
                                    DIR.bchanat,...
                                    DIR.matcode,...
                                    DIR.spmxdir,...
                                    DIR.oldmatcode,...
                                    tasktype);
                                xlist{end+1} = DIR.F.anat.xname{1}.shadowT1;
                                %--- U-file ---%
                                [uStatus(end+1),ufid] = wfu_U_scriptwrite( ...
                                    DIR.F.anat.uname{1}.shadowT1,...
                                    DIR.F.anat.logfile{1},...
                                    DIR.bchanat,...
                                    tasktype, ...
                                    DIR.norm{1},...
                                    cleanup,...
                                    subject,...
                                    DIR.F.anat.unixout{1},...
                                    DIR.F.anat.xname{1}.shadowT1, ...
                                    DIR.F.launchscript,...
                                    DIR.F.cpufinder,...
                                    DIR.F.anat.cpuout{1},...
                                    'nocompfile',...
                                    DIR.subject,...
                                    DIR.F.anat.matout{1});
                                anatulist{end+1} = {DIR.F.anat.uname{1}.shadowT1};
                            end	% for n = 1:length(mainjobs{j}.spatial{s}.anat.normalise)
                        end	% if anatflag

                    case 'shadow_normalise'
                        shadrun = runvector;
                        for r = runvector
                            %for n = 1:length(mainjobs{j}.spatial{s}.shadow_normalise)
                            task = mainjobs{j}.spatial{s}.shadow_normalise{r};
                            jobs{1}.spatial{1}.normalise{1} = task;
                            tasktype = 'shadow_normalization_EPI';
                            %--- MAT-file ---%
                            wfu_save(DIR.F.matname{shadrun}.shadowEPI,jobs,'jobs');
                            matlist{end+1} = DIR.F.matname{shadrun}.shadowEPI;
                            %--- X-file ---%
                            snmat = task.write.subj.matname{1};
                            [xStatus(end+1),xfid] = wfu_X_scriptwrite( ...
                                DIR.F.xname{shadrun}.shadowEPI,...
                                DIR.F.matname{shadrun}.shadowEPI, ...
                                DIR.F.uname{shadrun}.shadowEPI,...
                                DIR.bchrun{shadrun},...
                                DIR.matcode, ...
                                DIR.spmxdir,...
                                DIR.oldmatcode,...
                                tasktype,...
                                snmat);
                            xlist{end+1} = DIR.F.xname{shadrun}.shadowEPI;
                            %--- U-file ---%
                            [uStatus(end+1),ufid] = wfu_U_scriptwrite( ...
                                DIR.F.uname{shadrun}.shadowEPI,...
                                DIR.F.logfile{shadrun}, ...
                                DIR.bchrun{shadrun},...
                                tasktype,...
                                DIR.norm{shadrun},...
                                cleanup, ...
                                subject,...
                                DIR.F.unixout{shadrun},...
                                DIR.F.xname{shadrun}.shadowEPI, ...
                                DIR.F.launchscript,...
                                DIR.F.cpufinder,...
                                DIR.F.cpuout{shadrun}, ...
                                'nocompfile',...
                                DIR.subject,...
                                DIR.F.matout{shadrun});
                            ulist{shadrun}{end+1} = DIR.F.uname{shadrun}.shadowEPI;
                            shadrun = shadrun + 1;
                        end % r = runvector

                    case 'normalise'
                        epirun = runvector;
                        for r = runvector
                            %for n = 1:length(mainjobs{j}.spatial{s}.normalise)
                            task = mainjobs{j}.spatial{s}.normalise{r};
                            jobs{1}.spatial{1}.normalise{1} = task;
                            tasktype = 'EPI_normalization';
                            %--- MAT-file ---%
                            wfu_save(DIR.F.matname{epirun}.normEPI,jobs,'jobs');
                            matlist{end+1} = DIR.F.matname{epirun}.normEPI;
                            %--- X-file ---%
                            [xStatus(end+1),xfid] = wfu_X_scriptwrite( ...
                                DIR.F.xname{epirun}.normEPI,...
                                DIR.F.matname{epirun}.normEPI,...
                                DIR.F.uname{epirun}.normEPI, ...
                                DIR.bchrun{epirun},...
                                DIR.matcode,...
                                DIR.spmxdir,...
                                DIR.oldmatcode,...
                                tasktype);
                            xlist{end+1} = DIR.F.xname{epirun}.normEPI;
                            %--- U-file ---%
                            [uStatus(end+1),ufid] = wfu_U_scriptwrite( ...
                                DIR.F.uname{epirun}.normEPI,...
                                DIR.F.logfile{epirun},...
                                DIR.bchrun{epirun},...
                                tasktype, ...
                                DIR.norm{epirun},...
                                cleanup,...
                                subject,...
                                DIR.F.unixout{epirun},...
                                DIR.F.xname{epirun}.normEPI, ...
                                DIR.F.launchscript,...
                                DIR.F.cpufinder,...
                                DIR.F.cpuout{epirun},...
                                'nocompfile', ...
                                DIR.subject,...
                                DIR.F.matout{epirun});
                            ulist{epirun}{end+1} = DIR.F.uname{epirun}.normEPI;
                            epirun = epirun + 1;
                        end % r = runvector

                    case 'smooth'
                        tasktype = 'smoothing';
                        for r = runvector
                            %for n = 1:length(mainjobs{j}.spatial{s}.smooth)
                            smrun = r;
                            jobs{1}.spatial{1}.smooth = mainjobs{j}.spatial{s}.smooth{r};
                            %--- MAT-file ---%
                            wfu_save(DIR.F.matname{smrun}.smooth,jobs,'jobs');
                            matlist{end+1} = DIR.F.matname{r}.smooth;
                            %--- X-file ---%
                            [xStatus(end+1),xfid] = wfu_X_scriptwrite( ...
                                DIR.F.xname{smrun}.smooth,...
                                DIR.F.matname{smrun}.smooth,...
                                DIR.F.uname{smrun}.smooth, ...
                                DIR.bchrun{smrun},...
                                DIR.matcode,...
                                DIR.spmxdir,...
                                DIR.oldmatcode,...
                                tasktype);
                            xlist{end+1} = DIR.F.xname{smrun}.smooth;
                            %--- U-file ---%
                            [uStatus(end+1),ufid] = wfu_U_scriptwrite( ...
                                DIR.F.uname{smrun}.smooth,...
                                DIR.F.logfile{smrun},...
                                DIR.bchrun{smrun},tasktype, ...
                                DIR.norm{smrun},...
                                cleanup,...
                                subject,...
                                DIR.F.unixout{smrun},...
                                DIR.F.xname{smrun}.smooth, ...
                                DIR.F.launchscript,...
                                DIR.F.cpufinder,...
                                DIR.F.cpuout{smrun},...
                                DIR.F.swrcomp{smrun}, ...
                                DIR.subject,...
                                DIR.F.matout{smrun},...
                                nruns,...
                                DIR.F.runsaredone,...
                                DIR.fixparadigm);
                            ulist{smrun}{end+1} = DIR.F.uname{smrun}.smooth;
                            % smrun = smrun + 1;
                        end	% r = runvector
                end	% switch field{1}
            end	% for s = 1:length(mainjobs{j}.spatial)
        end	% if isfield(mainjobs{j},'spatial')

        if isfield(mainjobs{j},'stats') & find(runvector)
            jobs=[];
            runcount=0;
            statcount=1;
            savejob=0;

            starts = min((runvector - 1) * 3 + 1);
            ends = max((runvector - 1) * 3 + 3);
            runindex = runvector(1) - 1;
            %for s = 1:length(mainjobs{j}.stats)
            for s = starts:ends
                tasktype = 'model';
                field    = fieldnames(mainjobs{j}.stats{s});
                %------------------------------------------------------------------
                %Construc all the stats jobs associated with each run before save
                %These are sequential substructures in mainjobs{j}.stats
                %So first 3 belong to run1 (spec,est,con), next 3 belong to run2,...
                %------------------------------------------------------------------
                switch field{1}
                    case 'fmri_spec'
                        jobs{1}.stats{statcount}.fmri_spec = mainjobs{j}.stats{s}.fmri_spec;
                        statcount = statcount + 1;

                    case 'fmri_est'
                        jobs{1}.stats{statcount}.fmri_est = mainjobs{j}.stats{s}.fmri_est;
                        statcount = statcount + 1;

                    case 'con'
                        jobs{1}.stats{statcount}.con = mainjobs{j}.stats{s}.con;
                        statcount = statcount + 1;
                        savejob   = 1;

                end  % switch field{1}

                %------------------------------------------------------------------
                %if savejob is 1, then the contrast field has been read
                %and we can write the run
                %-------------------------------------------------------------------

                if savejob
                    %--- MAT-file ---%
                    runcount = runcount + 1;
                    runindex = runindex + 1;
                    savejob=0;
                    statcount=1;
                    cleanup_matdirs = 1;

                    if find(runvector == runindex)
                        wfu_save(DIR.F.matname{runindex}.model,jobs,'jobs');
                        jobs=[];
                        %savejob=0;
                        %statcount=1;
                        %cleanup_matdirs = 1;
                        matlist{end+1} = DIR.F.matname{runindex}.model;
                        %--- X-file ---%
                        [xStatus(end+1),xfid] = wfu_X_scriptwrite( ...
                            DIR.F.xname{runindex}.model,...
                            DIR.F.matname{runindex}.model,...
                            DIR.F.uname{runindex}.model, ...
                            DIR.bchrun{runindex},...
                            DIR.matcode,...
                            DIR.spmxdir,...
                            DIR.oldmatcode,...
                            tasktype,DIR,wfujob,runindex);
                        xlist{end+1} = DIR.F.xname{runindex}.model;
                        %--- U-file ---%
                        [uStatus(end+1),ufid] = wfu_U_scriptwrite( ...
                            DIR.F.uname{runindex}.model,...
                            DIR.F.logfile{runindex},...
                            DIR.bchrun{runindex},...
                            tasktype, ...
                            DIR.norm{runindex},...
                            cleanup_matdirs,...
                            subject,...
                            DIR.F.unixout{runindex},...
                            DIR.F.xname{runindex}.model, ...
                            DIR.F.launchscript,...
                            DIR.F.cpufinder,...
                            DIR.F.cpuout{runindex},...
                            DIR.F.statscomp{runindex},...
                            DIR.subject, ...
                            DIR.F.matout{runindex});
                        ulist{runindex}{end+1} = DIR.F.uname{runindex}.model;
                    end % if find(runvector == runindex) 
                end  % if savejob
            end % for s = starts:ends
            if runcount ~= length(runvector)
                error(sprintf('Preprocessing and analysis do not use same number of runs'));
            end
        end % if isfield(mainjobs{j},'stats') & find(runvector)


        %--- verify that scripts exist ---%
        %if anatflag & isempty(runvector), ulist = anatulist; end
        missing = wfu_missing_scripts(matlist,xlist,ulist);
        if missing
            disp(sprintf('\nThe following scripts were not successfully created:'));
            disp(missing);
            error(sprintf('The scripts listed above were not successfully created\nAutoprocessing terminated.'));
        end
    else
        error('Currently, this program can''t handle multiple jobs except for WFU FIXED EFFECTS');
    end % if j == 1
end % for j = 1:length(mainjobs)

%=========================== FIXED EFFECTS ================================%

if fixedflag
    for j = 1:length(fixjobs)
        for f = 1:length(wfujob.fixedeff.refs), fixulist{f} = []; end
        fixmatlist  = [];
        fixxlist    = [];

        if isfield(fixjobs{j},'stats')
            jobs=[]; fixcount=0; statcount=1; savejob=0;
            for s = 1:length(fixjobs{j}.stats)
                tasktype = 'fixed_effects_model';
                field    = fieldnames(fixjobs{j}.stats{s});
                switch field{1}
                    case 'fmri_spec'
                        jobs{1}.stats{statcount}.fmri_spec = fixjobs{j}.stats{s}.fmri_spec;
                        statcount = statcount + 1;
                    case 'fmri_est'
                        jobs{1}.stats{statcount}.fmri_est = fixjobs{j}.stats{s}.fmri_est;
                        statcount = statcount + 1;
                    case 'con'
                        jobs{1}.stats{statcount}.con = fixjobs{j}.stats{s}.con;
                        statcount = statcount + 1;
                        savejob   = 1;
                end
                
                if savejob
                    %--- MAT-file ---%
                    fixcount = fixcount + 1;
                    wfu_save(DIR.F.fixmatname{fixcount},jobs,'jobs'); jobs=[]; savejob=0; statcount=1;
                    %save(DIR.F.matname{fixcount}.model,'jobs'); jobs=[]; savejob=0;
                    fixmatlist{end+1} = DIR.F.fixmatname{fixcount};
                    %--- X-file ---%
                    [xStatus(end+1),xfid] = wfu_X_scriptwrite( ...
                        DIR.F.fixxname{fixcount},DIR.F.fixmatname{fixcount},DIR.F.fixuname{fixcount}, ...
                        DIR.fixparadigm{fixcount},DIR.matcode,DIR.spmxdir,DIR.oldmatcode,tasktype, ...
                        DIR,wfujob.fixedeff,j);
                    fixxlist{end+1} = DIR.F.fixxname{fixcount};
                    %--- U-file ---%
                    [uStatus(end+1),ufid] = wfu_U_scriptwrite( ...
                        DIR.F.fixuname{fixcount},DIR.F.fixlogfile{fixcount},DIR.fixparadigm{fixcount},tasktype, ...
                        'nodatapath','nofilestocleanup',subject,DIR.F.fixunixout{fixcount},DIR.F.fixxname{fixcount}, ...
                        DIR.F.launchscript,DIR.F.cpufinder,DIR.F.fixcpuout{fixcount},DIR.F.fixcomp{fixcount},DIR.subject, ...
                        DIR.F.fixmatout{fixcount},DIR);
                    fixulist{fixcount}{end+1} = DIR.F.fixuname{fixcount};
                end 
            end % for s = 1:length(fixjobs{j}.stats)
        else
            error('job{2} if used for FIXED EFFECTS must have .stats field');
        end % if isfield(fixjobs{j},'stats')
    end	% for j = 1:length(fixjobs)
end	% if fixedflag
