function files = wfu_select(directory,pattern,type,frames)

%   list all files in a directory that match the regular 
%   expression input (uses spm_select) 
%
%   FORMAT files = wfu_select(directory,pattern,type,frame)
%
%   files       - character array of files that match regexp
%
%   directory   - directory to search for files
%   pattern     - regular expression of string to match  
%   type        - 'any' (default) or 'extimage' for images
%   frames      - (1/0) flag to return multivol filenames
%                 (xxx.img) or individual volumes (xxx.img,1) 
%                 Note that type must be set to 'extimage' to 
%                 use this flag
%
%   EXAMPLE files = wfu_select(pwd,'^subj01.*$','extimage',1) 
%____________________________________________________________

list  = []; 
files = []; 

if nargin<4 || isempty(frames),     frames     = 0;         end
if nargin<3 || isempty(type),       type       = 'any';     end
if nargin<2 || isempty(pattern),    pattern    = '.*';      end
if isempty(directory),              directory  = pwd;       end

F = dir(directory);
for i = 1:length(F)
    if ~F(i).isdir
        list{end+1} = F(i).name;
    end
end

selected = spm_select('Filter',list,type,pattern);
if strcmp(lower(type),'extimage') & frames
    for j = 1:length(selected)
        disp(sprintf('Reading header %i of %i',j,length(selected)));
        selected{j} = fullfile(directory,selected{j});
        header      = nifti(selected{j}); 
        for k = 1:header.dat.dim(4)
            files{end+1} = [selected{j},',',num2str(k)];
        end
    end   
else
    for j = 1:length(selected)
        files{j} = fullfile(directory,selected{j});
    end
end

files = files'; 

return        
