function [nstruc,cmd] = wfu_setfield(structure,field,value)
%%------------------------------------------------------------------------------
%This program will take structure subfields and assign them to the parent structure
%This is useful for reading ref functions with direct substructure assignment
%-------------------------------------------------------------------------------
%---inputs
%	structure = parent structure
%	field	  = structure subfield string to be created in structure
%	value     =  value to assign to structure field
%
%---outputs
%	nstruc  = new structure with value assigned to subfield
%	cmd	=  cmd string being evaluated using setfield
%---example
%	ref.TR = 2
%	field = 'realign.estimate'
%	value = 1
%	ref = wfu_setfield(ref,field,value);
%
%	ref now consists of:
%	ref.TR = 2
%	ref.realign.estimate = 1
%
%------------------------------------------------------------------------------

comma = [];
cmd = [];
rem = field;
while length(rem)
 	[nstring,rem] = strtok(rem,'.');
	cmd = [cmd comma '''' nstring ''''];
	comma = ',';
end

cmd = ['setfield(structure,' cmd ',value)'];
nstruc = eval(cmd);
