function wfu_waitfor(filename,maxminutes) 

%   Halts program until specified file is found 
%   FORMAT wfu_waitfor(filename,maxminutes)
%   
%   filename    - name of file to wait for 
%   maxminutes  - maximum number of minutes to wait for file.
%                 When time is up, the program will error out
%____________________________________________________________

if nargin < 2 
    maxminutes = inf; 
end

count = 0; 

while 1 
    if exist(filename,'file')
        return
    end
    pause(30);
    count = count + .5;
    if ~mod(count,5)
        fprintf('Waiting %i minutes for ''%s''',count,filename);
    end
    if count >= maxminutes
        error(sprintf('Maximum wait time for %s has been exceeded. Aborting.',mfilename)); 
    end
end

