function [tmap,u, Pz, Pu, Qu, Pk, Pn]  = wfu_auto_cutoff2(wfu_params)
%Program for automatically choosing u threshold for activation maps

%Pz      = spm_P(1,0,   U,df,STAT,1,n,S);% uncorrected p value
%Pu      = spm_P(1,0,   U,df,STAT,R,n,S);% FWE-corrected {based on Z)
%Qu      = spm_P_FDR(   U,df,STAT,n,QPs);% FDR-corrected {based on Z)
%[Pk Pn] = spm_P(1,N(i),u,df,STAT,R,n,S);% [un]corrected {based on k)

%wfu_params.swd = 
%wfu_params.Ic = 2;
%wfu_params.u = 1.5;
%wfu_params.k = 0;
%wfu_params.correction = [];	% FWE; FDR



%-Extract data from xSPM
%-----------------------------------------------------------------------
[SPM,xSPM] = wfu_spm_getSPM5(wfu_params);
S     = xSPM.S;
VOX   = xSPM.VOX;
DIM   = xSPM.DIM;
n     = xSPM.n;
STAT  = xSPM.STAT;
df    = xSPM.df;
u     = xSPM.u;
M     = xSPM.M;
k     = xSPM.k;
QPs   = xSPM.Ps;

if STAT~='P'
    R     = xSPM.R;
    FWHM  = xSPM.FWHM;
end

units = {'mm'};

DIM   = DIM > 1;				% dimensions
VOX   = VOX(DIM);				% scaling

if STAT~='P'
    FWHM  = FWHM(DIM);				% Full width at max/2
    FWmm  = FWHM.*VOX; 				% FWHM {units}
    v2r   = 1/prod(FWHM);				% voxels to resels
    k     = k*v2r;					% extent threshold in resels
    R(find(~DIM) + 1) = [];				% eliminate null resel counts
end

QPs   = sort(QPs(:));				% Needed for FDR


%----------------Compute the auto-cutoff here------------------------
if ~exist('minvalue','var'), minvalue = 1.5; end;
if ~exist('maxvalue','var'), maxvalue = 10; end;
if ~exist('percentage','var'), percentage = 0.01; end;

u = minvalue;
tmap = [SPM.swd '/' xSPM.Vspm.fname];
fh = spm_vol(tmap);
cube = spm_read_vols(fh);
%cube = xSPM.Z(:);
temp = find(cube > 0);
%----------------------------------------------
%If nothing surviving just return the cutoff
%----------------------------------------------
if ~isempty(temp)
	voxel_cut = ceil(length(temp) * percentage);
	%---------------------------------------------------
	%Here is a sort routine for returning exact cutoff
	%---------------------------------------------------
	lsort = sort(cube(temp));
	index = length(lsort) - voxel_cut;
	if index, u = lsort(index); end
	if u > maxvalue, u = maxvalue; end;
end

%U=u;
U = wfu_params.u;
if wfu_params.autocutoff, U = u; end;
u=U;
c = 1;
Pz      = spm_P(1,0,   U,df,STAT,1,n,S);% uncorrected p value
Pu      = spm_P(1,0,   U,df,STAT,R,n,S);% FWE-corrected {based on Z)
Qu      = spm_P_FDR(   U,df,STAT,n,QPs);% FDR-corrected {based on Z)
[Pk Pn] = spm_P(1,k,U,df,STAT,R,n,S);% [un]corrected {based on k)


% cluster level [un]corrected {based on k):  Pk is corrected for extent, Pn is uncorrected for extent:
%[Pk Pn Em En EN] = spm_P(1,k,u,df,STAT,R,n,S);
%sprintf('Expected voxels per cluster, <k> = %0.3f',En/v2r);
%sprintf('Expected number of clusters, <c> = %0.2f',Em*Pn);
%map_level corrected p-value (based on number of clusters for given height and extent) set_level:
%Pc = spm_P(c,k,u,df,STAT,R,n,S);
%map_level corrected p-value (based on number of clusters for given height only):
%Pomnibus = spm_P(c,0,u,df,STAT,R,n,S);
%sprintf('Height threshold: %c = %0.2f, p = %0.3f (%0.3f)',...
%		 STAT,u,Pz,Pu);
%sprintf('Extent threshold: k = %0.0f voxels, p = %0.3f (%0.3f)',...
%	         k/v2r,Pn,P);
%sprintf('Expected voxels per cluster, <k> = %0.3f',En/v2r);
%sprintf('Expected number of clusters, <c> = %0.2f',Em*Pn);
%sprintf('Expected false discovery rate, <= %0.2f',Qu);
%sprintf('Degrees of freedom = [%0.1f, %0.1f]',df);
%['FWHM = ' sprintf('%0.1f ', FWmm) units{:} '; ' ...
%                   sprintf('%0.1f ', FWHM) '{voxels}; '];
%sprintf('Volume: %0.0f; %0.0f voxels; %0.1f resels', ...
%                 S*prod(VOX),S,R(end));
%['Voxel size: ' sprintf('%0.1f ',VOX) units{:} '; ' ...
%	  sprintf('(resel = %0.2f voxels)',prod(FWHM))];


%%------------Generate the T-map for overlay-----------
wfu_params.k = 0;
wfu_params.u = u;
wfu_params.correction = 'none';
[SPM,xSPM] = wfu_spm_getSPM5(wfu_params);
tmap = fullfile(SPM.swd,xSPM.Vspm.fname);
