function wfu_dicom_magilla(flags)

%_________________________________________________________________________________________
%This is an example of taking an activation map all the way through the following steps:
%1. Generate a thresholded Tmap
%2. Overlay on an anatomic image
%3. Convert fused image to DICOM
%4. Send DICOM image to PACS
%The DICOM conversion uses the existing dicom header information of the native space anatomic image (if present)
%the wfu_DICOM routine saves a dicom header with each DICOM->analyze converted volume that can be used for this purpose

%flags.threshold
%		enabled = 1
%		autocutoff = 1
%		swd = matdir
%		Ic = 1;  %Tmap contrast number
%		u = 1.5; %minimum cutoff
%		k = 0;   %cluster extent
%		correction = [];  %leave empty since this is the autocutoff function	
%flags.fuse
%		enabled = 1
%		anatomic = anatomic filename 
%		normalized_target = 0		%Not yet implemented
%		tmap = tmap filename  (will automatically fill this if autothreshold is enabled)
%flags.convert
%		enabled = 1;
%		clear_dir=1;
%		verbose=1;
%		modifyhdr=[];
%		series=90;	starting series number
%		fuse_file  = fused file (will automatically fill if fuse enabled)
%		dicom_template = dicom_template to use(will automatically fill if fuse enabled)
%flags.send
%		enabled = 1;
%		pacs_host = 'nwg1';
%		pacs_host_ip =  '152.11.20.3';
%		pacs_port = 104;
%		pacs_aetitle = 'NWG1'
%		pacs_dbdir = 'fmri';		%-c flag
%		send_inc = 1;
%		verbose = 1;
%		erase = 0;
%		pacs_sender = 'ansir5a';        % will not use this arg so local host is sender
%		sending_pacs = 1
%__________________________________________________________________________________________
%sdir = '/ansir1/maldjian/WFU_work/clinical/caftest';
%matdir = fullfile(sdir,'RUN1','spm_mat');
%anatomic = fullfile(sdir,'analyze','caf4006b-0003-001-0001-0124-efgre3d.img');
%sag = fullfile(sdir,'analyze','caf4006b-0002-001-0009-0009-memp.img');
%tmap = fullfile(matdir,'spmT_0001.img');

%----------Set some defaults------------------------
 
	def_flags.threshold.enabled = 0;
	def_flags.threshold.autocutoff = 1;
	def_flags.threshold.swd = [];
	def_flags.threshold.Ic = 1;  %Tmap contrast number
	def_flags.threshold.u = 1.5; %minimum cutoff
	def_flags.threshold.k = 0;   %cluster extent
	def_flags.threshold.correction = 'none';  %leave empty since this is the autocutoff function	


	def_flags.fuse.enabled = 1; 
	def_flags.fuse.anatomic = [];
	def_flags.normalized_target = 0;
	def_flags.fuse.tmap = [];
	def_flags.fuse.threshold = [];


	def_flags.convert.enabled = 1;
	def_flags.convert.clear_dir = 1;
	def_flags.convert.verbose = 1;
	def_flags.convert.modifyhdr = [];
	def_flags.convert.series = 90;


	def_flags.send.enabled = 0;

	def_flags.send.pacs_host = 'KENNY';
	def_flags.send.pacs_host_ip =  '152.11.233.220';
	def_flags.send.pacs_port = 4006;
	def_flags.send.pacs_aetitle = 'FMRI'; %-a flag
	def_flags.send.pacs_dbdir = 'MRAW';		%-c flag

	def_flags.send.send_inc = 1;
	def_flags.send.verbose = 1;
	def_flags.send.erase = 0;
	def_flags.send.pacs_sender = 'ansir5a';
	def_flags.send.sending_pacs = 1;

flags = wfu_copy_flags(flags,def_flags);

dircon = wfu_directory_configuration(false);

p_fdr='';
if flags.threshold.u, p_fdr = sprintf('u%0.5g',flags.threshold.u); end;
if flags.threshold.enabled
	%Set defaults if not already set
	%This is important, otherwise SPM_getSPM thinks the model hasn't been estimated (checkmodality problem)
	global defaults
	defaults.modality = 'FMRI';
	if isempty(flags.threshold.swd),
		tmap = wfu_pickfile('Choose tmap');
		[matdir,fn,ext] = fileparts(tmap);
		flags.threshold.swd = matdir;
		flags.threshold.Ic = str2num(strrep(fn,'spmT_',''));
	end

	%---------------------Get the auto_cutoff-------------------

	[tmap,u, Pz, Pu, Qu, Pk, Pn]  = wfu_auto_cutoff2(flags.threshold);


	%----------pass variables to next step------------------------
	threshold = u;
	p_fdr = sprintf('P(FDR)<%0.5g',Qu);
	p_bon = sprintf('P(FWE)<%0.5g',Pu);
	flags.fuse.tmap =  tmap;
	flags.fuse.threshold = threshold;
end

if ~flags.fuse.enabled and flags.convert.enabled, flags.convert.fuse_file = tmap; end

%---------------------Generate the fused image file------------
if flags.fuse.enabled
	f = flags.fuse;
	if isempty(f.anatomic), 
		a = fileparts(f.tmap);
		a1 = fileparts(a);
		subjectdir = fileparts(a1);
		f.anatomic = wfu_pick_template(fullfile(subjectdir,dircon.anatdir));
	 end;
	f
	[fuse_file,dicom_template] = wfu_fuse(f.anatomic, f.tmap,f.threshold);

	%----------pass variables to next step------------------------
	flags.convert.fuse_file = fuse_file;
	flags.convert.dicom_template = dicom_template;

	%---------------Set the Series Description in the DICOM Header----------------------------------------------
	tasktext  = 'Left hand motor';
	tasktext = strtrim(wfu_extract_paradigm(f.tmap));
	tasktext = [tasktext ' ' strtrim(p_fdr)];
	flags.convert.modifyhdr.newhdr.SeriesDescription = tasktext;
	flags.convert.modifyhdr.existinghdr.SeriesDescription = tasktext;
end


%----------------------Convert to Dicom-----------------
if flags.convert.enabled
	c = flags.convert;
	%------------------------------------------------------------
	%Header mods that can be put in the new DICOM file
	%	modifyhdr.newhdr.SeriesNumber  = 777;
	%       modifyhdr.newhdr.StudyDescription = 'FMRI Study';
	%       modifyhdr.newhdr.SeriesDescription = 'FMRI Series';
	%       modifyhdr.newhdr.AdditionalPatientHistory = 'FUSION History';
	%------------------------------------------------------------
	[pth,fn,ext] = fileparts(c.fuse_file);
	[pth2,fn2,ext2] = fileparts(f.tmap);
	[pth3,fn3,ext3] = fileparts(pth2);
	[pth4,fn4,ext4] = fileparts(pth3);
	dsubdir = ['series' num2str(str2num(strrep(fn4,'RUN','')) + c.series)];
        c.modifyhdr.existinghdr.SeriesNumberOverwrite =  str2num(strrep(fn4,'RUN','')) + c.series;
 
	if ~exist('c.dicom_dir','var')
		subdir = 'dicom';
	        warning off MATLAB:MKDIR:DirectoryExists
		mkdir(pth,subdir);
		c.dicom_dir = fullfile(pth,subdir);
	end

	c.dicom_dir = fullfile(c.dicom_dir,dsubdir);
	if ~exist('c.dicom_dir','dir')
	        warning off MATLAB:MKDIR:DirectoryExists
		[pth5,fn5,ext5] = fileparts(c.dicom_dir);
		mkdir(pth5,dsubdir);
	end


	flags.send.dicom_dir = c.dicom_dir;
	wfu_convert_to_dicom(c.fuse_file, c.dicom_dir, c.clear_dir, c.verbose, c.modifyhdr, c.dicom_template)

end

%----------------------Send to PACS----------------
if flags.send.enabled
	s = flags.send;
	wfu_send_to_pacs(s.pacs_host, s.pacs_host_ip, s.pacs_port, s.pacs_aetitle, s.pacs_dbdir, s.dicom_dir, s.send_inc, s.verbose, s.erase)
end
