function wfu_extra_processing_steps(inDir,outDir)

%   Perform extra steps, if any, in the WFU processing stream.
%   These steps will block further processing until complete.
%
%   FORMAT wfu_extra_processing_steps(inDir,outDir)
%   
%   inDir       - directory containing DICOM format images
%   outDir      - directory containing analyze files
%____________________________________________________________

%
disp('WFU extra processing ...')

% list MATLAB function calls here before the return statement
% 
% for example:
%
% disp('WFU extra processing ... step 1 ... perfusion')
% wfu_profusion_step
%
% disp('WFU extra processing ... step 2 ... misc')
% wfu_misc_step
%

try
  disp('WFU extra processing ... Segmenting T1 weighted image');
  wfu_segment_t1weighted_image(outDir);
catch
	errorInfo = lasterror;
	disp(sprintf('Error received: %s\n',errorInfo.message));
  disp('WFU extra processing ... Segmenting T1 weighted image failed');
end


return
