function task = wfu_extract_paradigm(spmt)
%Tries to find the paradigm text from either the task.flist file, or the paradigms.flist file
task = '';
[pth,fn,ext] = fileparts(spmt);
[rundir,matdir] = fileparts(pth);
[subjectdir,runnum] = fileparts(rundir);
taskfile = fullfile(rundir,'task.flist');
tasknum = 1;
if ~exist(taskfile,'file'),
	taskfile = fullfile(subjectdir,'paradigms.flist');
	if ~exist(taskfile,'file'), return; end
	tasknum = str2num(strrep(runnum,'RUN',''));
end
task = wfu_read_flist(taskfile);
task = task(tasknum,:);
return
