function [MT1,object2mni,target2mni,outfile] = wfu_findobject2target(object, target,mflags)
%__________________________________________________________________________
%Computes the affine transformation for object space to target space
%mflags.compute = 1  %write out the file
%mflags.clean = 0    %erase intermediate files
%mflags.warp = 1    %if you want to use spatial warps from sn3dfile (if 0, then uses affine only)
%Syntax:  mt = wfu_findobject2target(object,target,mflags)
%It uses the wfu_image2mni function to compute the respective transformation
%JAM  12-16-04
%__________________________________________________________________________
% The `.mat' files.
%
% This simply contains a 4x4 affine transformation matrix in a variable `M'.
% These files are normally generated by the `realignment' and
% `coregistration' modules.  What these matrixes contain is a mapping from
% the voxel coordinates (x0,y0,z0) (where the first voxel is at coordinate
% (1,1,1)), to coordinates in millimeters (x1,y1,z1).  By default, the
% the new coordinate system is derived from the `origin' and `vox' fields
% of the image header.
%  
% x1 = M(1,1)*x0 + M(1,2)*y0 + M(1,3)*z0 + M(1,4)
% y1 = M(2,1)*x0 + M(2,2)*y0 + M(2,3)*z0 + M(2,4)
% z1 = M(3,1)*x0 + M(3,2)*y0 + M(3,3)*z0 + M(3,4)
%
% Assuming that image1 has a transformation matrix M1, and image2 has a
% transformation matrix M2, the mapping from image1 to image2 is: M2\M1
% (ie. from the coordinate system of image1 into millimeters, followed
% by a mapping from millimeters into the space of image2).
%
% These `.mat' files allow several realignment or coregistration steps to be
% combined into a single operation (without the necessity of resampling the
% images several times).  The `.mat' files are also used by the spatial
% normalisation module.
%__________________________________________________________________________

%---------------------------------------------------
%Here is the logic for the sn3d transformations
%---------------------------------------------------
%object2target = target2tal \ object2tal
%magnet_ax2MNIv = Affine;
%ax2magnet = MF;
%epi2magnet = Mepi;
%epi2ax= MF\Mepi;
%ax2axMNIv = Affine;
%ax2MNIw = MG/Affine;
%epi2MNIw = (MG/Affine) * (MF\Mepi)

%Affine = native_display -> MNI display
%MG	= MNI_display	 -> full tal
%MF	= native_display -> magnet
%sag->ax = M_ax\M_sag
%MNI_origin = inv(MG) * acpc' = MG\acpc'
%full_tal->native_display = Affine/MG
%native_display->full_tal = MG/Affine = inv(Affine/MG)
%native_display->full_tal = MNI_display->full_tal) / (native_display->MNI_display)
%object2fulltal = (MG/Affine) * (MF\M0)
%sag2fulltal	= (native_ax_display ->full_tal) * (sag2ax)

%If normalized object2tal = Mo
%If not normalized:
%	[Dims,Affine,MF,MG,Tr] = load_params(sn3d);
%	object2tal = (MG/Affine) * (MF\Mo) ;

%If normalized target2tal = Mt
%If not normalized:
%	[Dims,Affine,MF,MG,Tr] = load_params(sn3d);
%	target2tal = (MG/Affine) * (MF\Mt) ;
%_______________________________________________
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%



[object2mni,o_norm,sn3d_object] = wfu_image2mni(object);
[target2mni,t_norm,sn3d_target] = wfu_image2mni(target);
MT1 = target2mni \ object2mni;
MT = MT1;
outfile = [];
if ~exist('mflags','var')
	mflags.clean = 0;
	mflags.warp = 1;
	mflags.compute = 1;
end
%look for inverse transform if only target is native and object is normalized
if mflags.warp
    if (o_norm + t_norm) == 1
    	%If the object is normalized, it needs the inverse transform to native space
    	if o_norm
    		inv_flag = 0;
    		if o_norm, [object,inv_flag] = wfu_inverse_normalize(object,target); inv_file = object; end
    		%if t_norm, [target,inv_flag] = wfu_inverse_normalize(target,object); inv_file = target; end
    		if inv_flag, 
    			VO = spm_vol(object); 
    			MT = [];
    			MT1 = VO.mat; 
            end
        end
    	%If the target is in normalized space, check the flags to see if you want to use affines only, or warps as well to send object to target
    	if t_norm
    		if sn3d_object,
    			disp(['using spatial warps with ' sn3d_object]);
    			Vo = spm_write_sn(object,sn3d_object);
    			disp('writing forward transform to MNI space');
    			spm_write_vol(Vo,Vo.dat);
            end
        end
    end
end    


if mflags.compute
	[pth,fn,ext] = fileparts(object);
	outfile = fullfile(pth,['r' fn '.img']);
	disp(['reslicing to ' outfile]);
	flags.mean=0;
	flags.hold = 0;
	flags.which=1;
	flags.mask=0;
	flags.interp = 0;
	P = {target,object};
	wfu_spm_reslice(P,flags,MT);
    %spm_reslice(P,flags);
	%if mflags.clean and inv_flag, erase(inv_file); end;
	%---------------------------------------------------
	%If you want to write a matfile instead
	%you will need to copy the .img/.hdr to r.img/r.hdr
	%---------------------------------------------------
	%matfile = fullfile(pth,['r' fn '.mat']);
	%V = spm_vol(target);
	%[normalized,mat0,M0,spm99_norm] = wfu_isnormalized(target,V);
	%M = M0 * MT;
	%mat = mat0 * MT;
	%save(matfile,'M','mat');

end
return

%_______________________________________________
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%_______________________________________________
function [wimage,inv_flag] = wfu_inverse_normalize(image,image2)
%------------------------------------------------------------------------------
%This routine will look for and apply the inverse normalization parameter set
%to a normalized image
%-----------------------------------------------------------------------------
%First verify that the image is not a native space image
wimage = image;
inv_flag = 0;
V = spm_vol(image);
[normalized,mat,M,spm99_norm] = wfu_isnormalized(image,V);
if ~normalized, return; end;

%-----------------------------------------------
%Now search for the inverse normalization file
%-----------------------------------------------
[pth,fname,ext] = fileparts(image);
filter_inverse  = '*inv_sn.mat';
sn3dfile = wfu_select(pth,['^','.',filter_inverse]);

%---------------------------------------------
%If not found, try the object/target path
%---------------------------------------------
if isempty(sn3dfile); 
	if exist('image2')	
		[pth,fname,ext] = fileparts(image2);
		sn3dfile = wfu_select(pth,['^','.',filter_inverse]);
	end
end
if isempty(sn3dfile); return;  end;

%--------------------------------------------------
%We found the inverse file, so let's write it out
%--------------------------------------------------
inv_flag = 1;
sn3dfile = sn3dfile{1};
%prm = load(sn3dfile);
%[bb,vx] = bbvox_from_V(prm.VG);
%flags = struct('interp',1,'vox',vx,'bb',bb,'wrap',[0 0 0],'preserve',0);
%[flags.bb, flags.vox] = bbvox_from_V(prm.VG(1));
disp(['computing inverse transform with ' sn3dfile]);
VO = spm_write_sn(image,sn3dfile);
disp('writing inverse transform');
spm_write_vol(VO,VO.dat);
wimage = VO.fname;
return;
%_______________________________________________
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%_______________________________________________



%_______________________________________________________________________
function [bb,vx] = bbvox_from_V(V)
vx = sqrt(sum(V.mat(1:3,1:3).^2));
if det(V.mat(1:3,1:3))<0, vx(1) = -vx(1); end;

o  = V.mat\[0 0 0 1]';
o  = o(1:3)';
bb = [-vx.*(o-1) ; vx.*(V.dim(1:3)-o)]; 
return;
%_______________________________________________________________________




%_______________________________________________
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%_______________________________________________



function wfu_sn_compute(object,target)
Vt = spm_vol(target);
Vo = spm_vol(object);
MG = Vt.mat;
MF = Vo.mat;
Transform = [];
d1 = Vt.dim(1:3);
d2 = [8 8 8];
[thdr,tvox,torigin,toff] = wfu_header_info(target);
d3 = tvox;
d4 = torigin;
d5 = Vo.dim(1:3);
[ohdr,ovox,oorigin,ooff] = wfu_header_info(object);
d6 = ovox;
Dims = [d1;d2;d3;d4;d5;d6];
mgc = 960209;
Affine = target2mni/object2mni;
[pth,fn,ext] = fileparts(object);
sn3dfile = fullfile(pth,'object_sn3d.mat');
save(sn3dfile,'mgc','MG','MF','Dims','Transform','Affine');
VG = Vt;
VF = Vo;
flags.smosrc = 8;
flags.smoref = 0;
flags.regtype = 'mni'
flags.weight = '';
flags.cutoff = 25;
flags.nits = 16;
flags.reg = 1;
flags.wtsrc = 0;
Tr = [];
snfile = fullfile(pth,'object_sn.mat');
save(snfile,'VG','VF','flags','Tr','Affine');
%spm_write_sn(object,sn3dfile,flags);
return




function [hdr,vox,origin,off] = wfu_header_info(imagename)
[pth,nam,ext] = fileparts(imagename);
hfname        = fullfile(pth,[nam '.hdr']);
hdr=[];
vox = [];
origin = [];
off = [];
if exist(hfname) == 2,
	% Read as much information as is stored in the ANALYZE header.
	% Assume transverse slices.
	hdr = spm_read_hdr(hfname);
	if isempty(hdr),
		error(sprintf('Can''t read header for "%s"\n', imagename));
	end
	if any(hdr.hist.origin(1:3)),
		origin = hdr.hist.origin(1:3);
	else,
		origin = (hdr.dime.dim(2:4)+1)/2;
	end;
	vox    = hdr.dime.pixdim(2:4);
	if all(vox == 0), vox = [1 1 1]; end;
	off    = -vox.*origin;
end
return



