function wfu_mat_fields(fname)

matFile = wfu_str_fix(fname,'se','mat');
if exist(matFile) 
    load(matFile);
    
    infoFile    = wfu_str_fix(matFile,'se','info');
    infoText    = wfu_read_info(infoFile);
    landmark    = infoText.HorizFrameOfRef;
    wfu_fields  = struct( ... 
        'wfu_RepetitionTime',           infoText.RepetitionTime, ...
        'wfu_EchoTime',                 infoText.EchoTime, ...
        'wfu_InversionTime',            infoText.InversionTime, ...
        'wfu_PulseSeqName',             infoText.PulseSeqName, ... 
        'wfu_PlaneType',                infoText.PlaneType, ...
        'wfu_PatientPosition',          infoText.PatientPosition, ...
        'wfu_PatientID',                infoText.PatientID, ...
        'wfu_LocationsInAcquisition',   infoText.NumberOfSlices, ...
        'wfu_SliceThickness',           infoText.SliceThickness, ...
        'wfu_SpacingBetweenSlices',     infoText.SpacingBetweenSlices, ...
        'wfu_FrameOfReferenceUID',      infoText.FrameOfReferenceUID, ...
        'wfu_HorizFrameOfRef',          infoText.HorizFrameOfRef ...
        );
    if exist('M','var')
			save(matFile,'mat','M','landmark','wfu_fields');
		else
			save(matFile,'mat','landmark','wfu_fields');
		end
else
%    warning(sprintf('Could not append .mat file:\n\t%s\nFile was never created by spm_create_vol.m',fname));
		disp(sprintf('NOTICE: Creating a mat file for %s to hold WFU specific info.',fname));

    infoFile    = wfu_str_fix(fname,'se','info');
    infoText    = wfu_read_info(infoFile);
    landmark    = infoText.HorizFrameOfRef;
    wfu_fields  = struct( ... 
        'wfu_RepetitionTime',           infoText.RepetitionTime, ...
        'wfu_EchoTime',                 infoText.EchoTime, ...
        'wfu_InversionTime',            infoText.InversionTime, ...
        'wfu_PulseSeqName',             infoText.PulseSeqName, ... 
        'wfu_PlaneType',                infoText.PlaneType, ...
        'wfu_PatientPosition',          infoText.PatientPosition, ...
        'wfu_PatientID',                infoText.PatientID, ...
        'wfu_LocationsInAcquisition',   infoText.NumberOfSlices, ...
        'wfu_SliceThickness',           infoText.SliceThickness, ...
        'wfu_SpacingBetweenSlices',     infoText.SpacingBetweenSlices, ...
        'wfu_FrameOfReferenceUID',      infoText.FrameOfReferenceUID, ...
        'wfu_HorizFrameOfRef',          infoText.HorizFrameOfRef ...
        );
		save(matFile,'landmark','wfu_fields');
end

return
