function mergeOK = wfu_merge_3d(volumes,fname)

%   make 4D analyze volume from 3D analyze images
%   FORMAT mergeOK = wfu_merge_3d(volumes,fname)
%   
%   mergeOK     - indicates (un)successful merge
%                   0 = error merging images
%                   1 = successful 3D-->4D merge
%
%   volumes     - cell array of image files
%   fname       - name of 4D image to produce 
%
%   ##  v1.1 Kathy Pearson and Aaron Baer   ##
%   ##  Wake Forest University              ## 
%_________________________________________________

if ~iscell(volumes)
    volumes = cellstr(volumes); 
end

mergeOK = 0; 
nVol    = length(volumes); 
if nVol >= 2
    for x = 1:nVol
        currVol = volumes{x}; 
        disp(sprintf('appending file #%d of %d: %s',x,nVol,currVol));
        V = spm_vol(currVol);
        vol = spm_read_vols(V);
        nplane = size(vol,3);
%        V.fname = sprintf('%s,%d', fname, x);
				V.fname = fname;
        V.n = [x 1];
%
%       spm_write_vol(V, vol);
% spm_write_vol resets the scale
% spm_create_vol/spm_write_plane will not
%
        V = spm_create_vol(V);
        for p = 1:nplane
	    spm_write_plane(V, vol(:,:,p), p);
        end
%        spm_close_vol(V);
    end
    mergeOK = 1;
else
    %--- don't write 4D for only one 3D volume ---% 
    mergeOK = 0; 
end
return
