function wfu_send_to_pacs(pacs_host, pacs_host_ip, pacs_port, pacs_aetitle, pacs_dbdir, dicom_dir, send_inc, verbose, erase, pacs_sender)
%__________________________________________________________________________
%
% Syntax:
%     wfu_send_to_pacs(pacs_host, pacs_host_ip, pacs_port, pacs_aetitle, pacs_dbdir, dicom_dir, send_inc, verbose, erase, pacs_sender)
%     wfu_send_to_pacs(pacs_host, pacs_host_ip, pacs_port, pacs_aetitle, pacs_dbdir, dicom_dir, send_inc, verbose, erase)
%     wfu_send_to_pacs(pacs_host, pacs_host_ip, pacs_port, pacs_aetitle, pacs_dbdir, dicom_dir, send_inc)
%     wfu_send_to_pacs(pacs_host, pacs_host_ip, pacs_port, pacs_aetitle, pacs_dbdir, dicom_dir)
%
% Required Arguments:
%     pacs_host      name of PACS server (such as 'kenny')
%     pacs_host_ip   Internet Protocol number of the pacs server
%     pacs_port      PACS server port number (such as 4006)
%     pacs_aetitle   PACS server aetitle (such as 'FMRI')
%     pacs_dbdir     PACS server database directory (such as 'MRAW')
%     dicom_dir      local dir containing f*.dcm files to be sent to PACS
%
% Optional Arguments:
%    send_inc        # of DICOM files to send at one time
%                      (default is 1)
%    verbose         toggle indicating if text feedback is wanted
%                      (default is 1)
%    erase           toggle indicating if files that are successfully
%                       sent should be erased (default is 0)
%    pacs_sender     name of non-local host (such as 'ike')
%                       (default is local host)
%
% Description:
% All f*.dcm files in the dicom_dir will be sent to the pacs system
% as defined by the pacs arguments.  If the pacs_sender is not specified
% it is assumed to be the local host; when specified, an rsh command
% is used to send through the pacs_sender host.  Which CTN send_image
% command to use is determined by either the 'linux' or 'sunos'
% operating system.  These binaries are expected to reside in the same
% directory as the wfu_send_to_pacs.m program.
%
% KLP
% 09-15-06
%__________________________________________________________________________
%
if nargin < 6
        error('at least 6 arguments required');
    end
    if ~exist('send_inc', 'var')
        send_inc = 1;
    end
    if ~exist('verbose', 'var')
        verbose = 1;
    end
    if ~exist('erase', 'var')
        erase = 0;
    end
    hostname = lower(getenv('HOST'));
    if exist('pacs_sender', 'var')
        str = sprintf('rsh %s uname', pacs_sender);
        [badstatus, result] = unix(str);
        if badstatus
            error(sprintf('cannot get uname for pacs_sender: %s', pacs_sender));
        end
        uname = deblank(lower(result));
    else
        pacs_sender = hostname;
        uname = lower(getenv('OSTYPE'));
    end
    if strcmp(uname, 'solaris')
        uname = 'sunos';
    end
    code_path=which('wfu_send_to_pacs');
    [pathstr,name,ext,version] = fileparts(code_path);
    send_image_dir = pathstr;
    if strcmpi(uname, 'linux') || strcmpi(uname, 'sunos')
        send_binary = sprintf('%s/send_image_%s', send_image_dir, uname);
    else
        error('can send to PACS only from linux or sunos');
    end
    if verbose
        disp(sprintf('send binary: %s', send_binary));
    end
    dirstr = sprintf('%s/*.dcm', dicom_dir);
    dirlist = dir(dirstr);
    n = 0;
    if length(dirlist) > 0
        dicom_fnames = cellstr(char(dirlist.name));
        n = length(dicom_fnames);
    end
    if verbose
        disp(sprintf('number of files to send in total: %d', n));
        disp(sprintf('number of files to send at one time: %d', send_inc));
        disp(sprintf('pacs sender: %s', pacs_sender));
    end
    for j = 1:send_inc:n
         send_fname = cell(1,1);
        for k = 1:send_inc
            if k+j-1 <= n      
                send_fname{k} = fullfile(dicom_dir, dicom_fnames{j+k-1});
            end
        end
        k = length(send_fname);
        str_local = sprintf('%s -r -a %s -c %s %s %d ', ...
            send_binary, pacs_aetitle, pacs_dbdir, pacs_host_ip, pacs_port);
        for m = 1:k
            str_local = sprintf('%s %s', str_local, send_fname{m});
        end
        if strcmpi(hostname, pacs_sender)
            str = str_local;
        else
            str = sprintf('rsh %s -n "%s"', pacs_sender, str_local);
       end
        output = sprintf('sending image %s [%d of %d] to %s via %s', dicom_fnames{j}, j, n, pacs_host, pacs_sender);
        if verbose
            disp(output);
            disp(str);
        end
        [badstatus, result] = unix(str);
        if badstatus
            error('bad status on unix send to pacs');
        end
        if erase
            for m = 1:k
                if verbose
                    disp(sprintf('Erasing file: %s', send_fname{m}));
                end
                delete(send_fname{m});
            end
        end
    end
end
