function ok = wfu_write_infofile(fname,infoText)

%   Writes a text file (.info) that corresponds to a dicom
%   image series / analyze image
%   FORMAT wfu_write_infofile(fname,hdr,imgName)
%   
%   ok      - 
%   fname   - 
%   imgName - 
%
%   ##  v1.1, Aaron Baer, Wake Forest University ##
%____________________________________________________________
ok = 0;

%----- open new file for writing -----%
infoFID = fopen(fname,'wt');            

%------ write comments -----%
fprintf(infoFID, '%% This .info file contains parameters from the following: \n');
fprintf(infoFID, '%%     %s \n',infoText.Filename);
fprintf(infoFID, '%% Generated by %s on %s at %s \n', ...
    mfilename,datestr(now,1),datestr(now,14));
fprintf(infoFID, '%% ----------------------------------------------------------------------\n\n');


%------ write analyze volume parameters -----%
F = fieldnames(infoText); 
V = struct2cell(infoText);
for i = 1:length(F)
    field = F{i};
    value = V{i};
    fprintf(infoFID, '%s\t', field);
    if isa(value,'char')
        switch field
            case 'ScanDate'
                value = datestr(value,1);
                fprintf(infoFID,'%s\n',value);
            otherwise
                fprintf(infoFID,'%s\n', value);
        end
    elseif isa(value,'double')
        switch field
            case {'RepetitionTime','EchoTime','HorizFrameOfRef'}
                fprintf(infoFID,'%.2f\n',value);
            case {'Xdim','Ydim','PixelSizeX','PixelSizeY','PixelSizeZ'}
                fprintf(infoFID,'%.5f\n',value);
            otherwise
                fprintf(infoFID,'%d\n', value);
        end
    else
        warning(sprintf('Class unknown for variable:\n%s\nTreating as string')); 
        fprintf(infoFID,'%s\n', value);
    end
end
fprintf(infoFID, '\n%% ----------------------------------------------------------------------\n\n');


%------ Close file ---------------------------------------------------------
closetype = fclose(infoFID);
if closetype == 0 % 0=successful close
    ok = 1;
end;