function [ spmExist spmVersion spmNumericVersion] = wfu_exist_spm
%
% [ spmExist spmVersion spmNumericVersion] = wfu_exist_spm
%
% PURPOSE: A simple utility to check if SPM exists.  Also returns the SPM
%          version as a string and a number.
%
% CATEGORY: Analyze Utility 
%
% INPUTS: None
%
%
% OUTPUTS: 
%       spmExist      - Boolean flag indicating whether SPM is on the current
%                       path.
%
%       spmVer        - String returned from spm('ver')
%
%
%       spmNumericVer - Number indicating the version of SPM used.
%
% EXAMPLE:
%

%==========================================================================
% C H A N G E   L O G
% 
%--------------------------------------------------------------------------

spmExist = false;

if exist('spm','file') ~= 2
    error('SPM not found on your Matlab path. Please add it to your path');
else
    spmVersion        = spm('Ver');
    spmExist          = true;
    spmNumericVersion = str2double(spmVersion(4));
end