function [fullFileName, fileName] = wfu_get_analyze_name( inFileName, analyzeExtension)
%
% PURPOSE: 
%
% CATEGORY: Analyze IO 
%
% INPUTS: 
%
%
% 
% KEYWORD PARAMETERS:
%
%
% OUTPUTS: 
%
%
% EXAMPLE:
%

%==========================================================================
% C H A N G E   L O G
% 
%--------------------------------------------------------------------------

if nargin < 2 || isempty(analyzeExtension)
    analyzeExtension = 'base';
end

analyzeExtension = lower(analyzeExtension);

inCellFlag = iscell(inFileName);

if ~inCellFlag
 inFileName = {inFileName}; 
end

fullFileName = cell(1,length(inFileName));
fileName     = cell(1,length(inFileName));

for ii=1:length(fileName)
    
    [fullFileName{ii}, fileName{ii}] = local_get_analyze_filename( inFileName(ii), analyzeExtension);

end


if ~inCellFlag
   
    fullFileName = char(fullFileName{1});
    fileName     = char(fileName{1});
    
end



function [fullFileToWrite, fileToWrite] = local_get_analyze_filename( inFileName, analyzeExtension)

%
% Confirm that the file is an Analyze File to start
%

if (strcmp('.img', inFileName ) || ...
    strcmp('.hdr', inFileName)  || ...
    strcmp('.dicom',inFileName))
    error('Invalid Analyze extension specified (%s)', analyzeExtension);
end

%--------------------------------
% Be UNforgiving of analyzeFilename:
%--------------------------------
if iscell(inFileName)
    inFileNameString = char(inFileName{1});
else
    inFileNameString = char(inFileName);
end

[directory, rootFileName, extension] = fileparts(inFileNameString); 


if strcmp('base', analyzeExtension )

    if strcmp('.img', extension ) || strcmp('.hdr', extension) || strcmp('.dicom',extension)
        fileToWrite = strcat(rootFileName);
    else
        fileToWrite = strcat(rootFileName,extension);
    end

else

    if strcmp('.img', extension) || strcmp('.hdr', extension) || strcmp('.dicom',extension)

        fileToWrite = strcat(rootFileName,'.',analyzeExtension);
    else
        fileToWrite = strcat(rootFileName, extension,'.',analyzeExtension);
    end
end

fullFileToWrite = fullfile(directory, fileToWrite);

