function varargout = wfu_get_spm_dimensions(fileName)
%
% PURPOSE: - Returns the dimensions of the SPM Analyze file
%
% CATEGORY: SPM IO
%
% INPUTS:
%
%    fileName  - Name of the SPM Analyze file or the SPM header structure.
%
%
% KEYWORD PARAMETERS:
%
%    none
%
% OUTPUTS: 
%
%    stackSize - A 4D array containing [Xres, Yres, nSlices, nVolumes] 
%
%

%
% Input argument checks
%

%
% Read header
%

[spmFlag spmVer] = wfu_exist_spm;

if ~isstruct(fileName)
    spmHdr  = wfu_read_spm_hdr(fileName);
else
    spmHdr  = fileName;
end

switch lower(spmVer)

    case 'spm5'

        nDimensions = sum([ spmHdr.dim spmHdr.n(1) ]>1);
        nXRes       = spmHdr.dim(1);
        nYRes       = spmHdr.dim(2);
        nSlices     = spmHdr.dim(3);
        nVolumes    = spmHdr.n(1);

    case 'spm2'

        nDimensions = spmHdr.private.hdr.dime.dim(1);
        nXRes       = spmHdr.private.hdr.dime.dim(2);
        nYRes       = spmHdr.private.hdr.dime.dim(3);
        nSlices     = spmHdr.private.hdr.dime.dim(4);
        nVolumes    = spmHdr.private.hdr.dime.dim(5);

    otherwise

end


if nargout <= 1
    varargout{1} = [nXRes, nYRes, nSlices, nVolumes]; %, nDimensions];
else
    varargout{1} = nXRes;
    varargout{2} = nYRes;
    varargout{3} = nSlices;
    varargout{4} = nVolumes;    
    % varargout{5} = nDimensions;    
end
