function [fullFileName, fileName] = wfu_get_spm_name( inFileName, spmExtension)
%
% PURPOSE: 
%
% CATEGORY: Analyze IO 
%
% INPUTS: 
%
%
% 
% KEYWORD PARAMETERS:
%
%
% OUTPUTS: 
%
%
% EXAMPLE:
%

%==========================================================================
% C H A N G E   L O G
% 
%--------------------------------------------------------------------------

if nargin < 2 || isempty(spmExtension)
    spmExtension = 'base';
end

spmExtension = lower(spmExtension);

inCellFlag = iscell(inFileName);

if ~inCellFlag
 inFileName = {inFileName}; 
end

fullFileName = cell(1,length(inFileName));
fileName     = cell(1,length(inFileName));

for ii=1:length(fileName)
    
    [fullFileName{ii}, fileName{ii}] = local_get_spm_filename( inFileName(ii), spmExtension);

end


if ~inCellFlag
   
    fullFileName = char(fullFileName{1});
    fileName     = char(fileName{1});
    
end



function [fullFileToWrite, fileToWrite] = local_get_spm_filename( inFileName, spmExtension)

%
% Confirm that the file is an Analyze File to start
%

if (strcmp('.img',   inFileName )  || ...
    strcmp('.hdr',   inFileName )  || ...
    strcmp('.nii',   inFileName )  || ...
    strcmp('.dicom', inFileName )  || ...
    strcmp('.mat',   inFileName ) )
    error('Invalid SPM Analyze extension specified (%s)', spmExtension);
end

%--------------------------------
% Be UNforgiving of spmFilename:
%--------------------------------
if iscell(inFileName)
    inFileNameString = char(inFileName{1});
else
    inFileNameString = char(inFileName);
end

[directory, rootFileName, extension] = fileparts(inFileNameString); 


if strcmp('base', spmExtension )

    if strcmp('.img', extension ) || strcmp('.hdr', extension) ...
            || strcmp('.mat', extension) || strcmp('.nii', extension) || ...
            strcmp('.dicom', extension)
        fileToWrite = strcat(rootFileName);
    else
        fileToWrite = strcat(rootFileName,extension);
    end

else
    
    if strcmp('.nii', extension)
    
        fileToWrite = strcat(rootFileName,'.','nii');

    else

        if strcmp('.img', extension) || strcmp('.hdr', extension) ...
                || strcmp('.mat', extension) || strcmp('.dicom', extension)


            fileToWrite = strcat(rootFileName,'.',spmExtension);

        else
            fileToWrite = strcat(rootFileName, extension,'.',spmExtension);
        end
    end
end

fullFileToWrite = fullfile(directory, fileToWrite);

