function wfu_write_spm_img(fileName, volumeIn, sliceIndex, volumeIndex )
% 
% wfu_write_analyze_img(fileName, volumeIn, sliceIndex, volumeIndex )
%
% PURPOSE: Write an array to a SPM analyze file.
%
% CATEGORY: SPM IO 
%
% INPUTS: 
%
%   fileName    - Analyze file name to write to.
%
%   volumeIn    - Array to write to fileName.
%
%   sliceIndex  - Slice index of array. Default is ':'
%
%   volumeIndex - Volume index of array. Default is ':'
% 
%
% OUTPUTS: 
%
%   None
%
% EXAMPLE:
%
%  
% 

%==========================================================================
% C H A N G E   L O G
% 
%--------------------------------------------------------------------------

%
% Check if SPM exists before continuing
%

[ spmExist spmVer] = wfu_exist_spm;


%---------------------------------------------------------------------------
%Writes analyze file and header
%This will always write in big-endian format
%if datatype is not sent, data will be written in the datatype of volumeIn
%---------------------------------------------------------------------------

if iscell(fileName)
   fileName = fileName{1}; 
end


%
% *** Initialize Slice Index and Volume Index
%

if (nargin < 4) || isempty(volumeIndex)
    volumeIndex = ':';
end

if (nargin < 3) || isempty(sliceIndex)
    sliceIndex = ':';
end

%
% Read SPM header
%

imgFileName  = wfu_get_spm_filename(fileName, 'img');

spmHdr   = wfu_read_spm_hdr(imgFileName);

nXres    = spmHdr.dim(1);
nYres    = spmHdr.dim(2);
nSlices  = spmHdr.dim(3);
nVolumes = spmHdr.n(1);

[ sliceIndex  nSliceIndex  ]     = wfu_create_index_array(sliceIndex,  nSlices );
[ volumeIndex nVolumeIndex ]     = wfu_create_index_array(volumeIndex, nVolumes );


%
% 
%

if (nargin < 2) || isempty(volumeIn)
   volumeIn = zeros([ nXres nYres ]);
end

dimVolumeIn = [ size(volumeIn) ones(1,4-length(size(volumeIn))) ];
%
% Error checking to verify that the input volume matches the analyze header
%

if nXres ~= size(volumeIn,1)
    error('Size of volume in along the 1st dimenion does not match Analyze header');    
end

if nYres ~= size(volumeIn,2)
    error('Size of volume in along the 2nd dimenion does not match Analyze header');    
end

if nSliceIndex > nSlices
    error('Maximum slice index is greater than allowed by Analyze header.');    
end

if nVolumeIndex > nVolumes
    error('Maximum volume index is greater than allowed by Analyze header.');    
end

%
% Write Data
%
%spmDataType = [spm_type(dtname) spm_platform('bigend')];
%spmVol      = struct('fname', fname, 'dim', dim, 'dt', spmDataType, ...
%                'mat', mat, 'pinfo', [1 0 0]', 'descrip', 'WFU 4d write'); 
spmVol   = spm_vol(imgFileName);
spmVol4D = spmVol(1);  % Single instance from spmVol

for ii = 1:nVolumeIndex

    switch lower(spmVer)
      

% for t = 1:nvol
% %    disp([ver ' writing volume ' num2str(t) ' of ' num2str(nvol)]);
%     if t == 1 && strcmp(ver, 'SPM5')
%         V.n = [nvol 1];
%         V4 = spm_create_vol(V, 'noopen');
%     end

%     if strcmp(ver, 'SPM5')
%         V4.n = [t 1];
%     else
%         V.n = t;
%         V4 = spm_create_vol(V, 'noopen');
%     end

%     for p = 1:nplane
%         spm_write_plane(V4, data(:,:,p,t), p);
%     end

%     if strcmp(ver, 'SPM2')
%         spm_close_vol(V4);
%     end
% end

        case 'spm5'

            if ii == 1
                spmVol4D.n = [nVolumeIndex 1];
                spmVol4D   = spm_create_vol(spmVol4D, 'noopen');
            end
            
            spmVol4D.n = [volumeIndex(ii) 1];
            
        case 'spm2'            
            

            spmVol4D.n     = volumeIndex(ii);
            spmVol4D.fname = sprintf('%s,%d', imgFileName, volumeIndex(ii) );

        otherwise
            
    end

    %
    % Write one plane (i.e. slice at a time)
    %

    if dimVolumeIn(4) == 1
        iiVolumes = 1;
    else
        iiVolumes = ii;
    end
    spmVol4D       = spm_create_vol(spmVol4D, 'noopen');

    for jj = 1:nSliceIndex
        if dimVolumeIn(3) == 1  % This code is nece
            jjSlices = 1;
        else
            jjSlices = jj;
        end

        spm_write_plane(spmVol4D, squeeze(volumeIn(:,:,jjSlices,iiVolumes)), sliceIndex(jj));
    end

    

    %
    % Close SPM image volume
    %

    if strcmp(spmVer,'spm2')
        spm_close_vol(spmVol4D);
    end
end
