function wfu_copy_dicom(inFileName, outFileNameOrDir)
%
% PURPOSE: - To copy an SPM Analyze file from one directory to another.
%            Matlab system command is not used to maintain compatability 
%            across platforms. 
%
% CATEGORY: IO Utility
%
% INPUTS:
% 
%    inFileName       - Cell list of SPM analyze files to move.
%
%    outFileNameOrDir - Directory where to move the files.
% 
%
% OUTPUTS: 
%
%    moveOK  - Variable that returns true of false depending on whether merge
%               was successful.
%
% EXAMPLE:
%
%

 



%
%
%

inFileName = wfu_get_spm_filename(inFileName, 'dicom');

[ inDir inShortFileName ] = wfu_fileparts(inFileName, true);

%
% If outFileNameOrDir is a Dir add inFileName to it.
%
if exist(outFileNameOrDir,'dir') == 7
    outFileName = strcat(outFileNameOrDir,filesep, inShortFileName);
else
    outFileName = wfu_get_spm_filename(outFileNameOrDir,'dicom');
end

%
% Copy DICOM Info File if it exists 
%

if isunix
    unixCommand = sprintf('cp -rp %s %s', inFileName, outFileName);
    system(unixCommand);
else

    newDicomHdr   = dicominfo(inFileName);
    newDicomImage = dicomread(inFileName);

    dicomwrite(newDicomImage, outFileName, newDicomHdr);
end

