function [ipp, iop] = wfu_ge2dcm(tlhc, trhc, brhc, snorm, pixelsize_x, pixelsize_y)

col_L = -(brhc(1)-trhc(1));
col_P = -(brhc(2)-trhc(2));
col_S = (brhc(3)-trhc(3));
norm_col = norm([col_L;col_P;col_S]);
col_L = col_L./norm_col;
col_P = col_P./norm_col;
col_S = col_S./norm_col;

row_L = -(trhc(1)-tlhc(1));
row_P = -(trhc(2)-tlhc(2));
row_S = (trhc(3)-tlhc(3));
norm_row = norm([row_L;row_P;row_S]);
row_L = row_L./norm_row;
row_P = row_P./norm_row;
row_S = row_S./norm_row;

ip_L = -tlhc(1) + (row_L*pixelsize_x/2) + (col_L*pixelsize_y/2);
ip_P = -tlhc(2) + (row_P*pixelsize_x/2) + (col_P*pixelsize_y/2);
ip_S = tlhc(3) + (row_S*pixelsize_x/2) + (col_S*pixelsize_y/2);

ipp = [ip_L;ip_P;ip_S]';
iop = [row_L;row_P;row_S;col_L;col_P;col_S];

