%-----------------------------------------------------
% Function: wfu_get_p_header_revision(file)
% Purpose:  Determines the size of the header in the given P-File.
%
% Arguments:file =  File Id of P-File to read (must be set via prior call to Open())
%               or  Filename of file to read (will open, then close).
%
% Returns:  header_size = size in bytes of the P-File header
%           isa_new_pfile_flag = 1 if this is a new style (longer) P-File header, 0 otherwise
%-----------------------------------------------------

%     07          7.0      7.x                       39984    Big
%     08          7.0      8.x                       39984    Big
%     09          7.0      9.0 except for 9.0 CNV4   39984    Big
%     09          8.0      9.0 CNV4, 9.1, VH3        60464    Big
%     10          8.0      10.0 last SGI               "      Big
%     11          9.0      11.0 (1st PC/Linux)       61464   Little
%
% Where genesis_ver = MRIMAGEDATATYPE.im_verscre
%      rdb_hdr_rev = RDB_HEADER_REC.rdb_hdr_rdbm_rev
% 
%-JBob

function [rdbmRevision, endian ] = wfu_get_p_header_revision(fileName)

[headerSize, rdbmRevision, endian ] = wfu_get_p_header_size(fileName);

return;
