function [hdrLength  hdrOffset] = wfu_get_pfile_offsets(rdbmRevision)
%-----------------------------------------------------
% Function: wfu_get_pfile_offsets(file)
% Purpose:  Determines the size of the header in the given P-File.
%
% Arguments:file =  File Id of P-File to read (must be set via prior call to Open())
%               or  Filename of file to read (will open, then close).
%
% Returns:  header_size = size in bytes of the P-File header
%           isa_new_pfile_flag = 1 if this is a new style (longer) P-File header, 0 otherwise
%-----------------------------------------------------

%     07          7.0      7.x                       39984    Big
%     08          7.0      8.x                       39984    Big
%     09          7.0      9.0 except for 9.0 CNV4   39984    Big
%     09          8.0      9.0 CNV4, 9.1, VH3        60464    Big
%     10          8.0      10.0 last SGI               "      Big
%     11          9.0      11.0 (1st PC/Linux)       61464   Little
%                10.0      P File never released 
%     12         11.0      12.0                      66072   Little
%
%     14         14.3      14.3 
%
%     The 12.0 header increased in two places: the RDB_DATA_ACQ_TAB structure increased 
%     to 45056 bytes from 40960 bytes (+4096 bytes), and the SERIESDATATYPE structure 
%     increased to 2048 bytes from 1536 bytes (+512 bytes).
%
%
% Where genesis_ver = MRIMAGEDATATYPE.im_verscre
%      rdb_hdr_rev = RDB_HEADER_REC.rdb_hdr_rdbm_rev
% 
%-JBob

%
% Defaults for revision 9
%

hdrLength.PIXEL_HDR_LEN = 124;
hdrLength.SUITE_HDR_LEN = 116;

hdrLength.RAW_HDR_LEN      = 2048;
hdrLength.PER_PASS_TBL_LEN = 4096;
hdrLength.UNLOCK_TBL_LEN   = 4096;

hdrLength.DATA_ACQ_TBL_LEN = 2*20480;

hdrLength.NEX_TBL_LEN      = 2052;
hdrLength.NEX_ABORT_LEN    = 2052;

hdrLength.TOOLS_DATA_LEN   = 2048;

hdrLength.PRESCAN_HDR_LEN  = 0;    % This did not exist until 14

hdrLength.EXAM_HDR_LEN     = 1040;
hdrLength.SERIES_HDR_LEN   = 1536;
hdrLength.IMAGE_HDR_LEN    = 1536;


switch rdbmRevision
    
    case 14.3

        % Copied directly from the PSD Conversion cookbook for 14
        % 
        % hdrsize version 2/6/06
        %
        % GENESIS_DATABASE_REVISION = 14
        % RDB_RDBM_REVISION = 14.3
        %
        % Primary Raw Header Structure:
        % sizeof(POOL_HEADER)         = 145908
        %
        % Raw Header Substructures:
        %    sizeof(RDB_HEADER_REC)   = 2048
        %    sizeof(RDB_PER_PASS_TAB) = 16384
        %    sizeof(RDB_DATA_ACQ_TAB) = 98304
        %    sizeof(RDB_NEX_TYPE)     = 2052 <=== Not 8-byte multiple
        %    sizeof(TOOLSDATA)        = 2048
        %    sizeof(PRESCAN_HEADER)   = 1500 <=== Not 8-byte multiple
        %    sizeof(EXAMDATATYPE)     = 1040
        %    sizeof(SERIESDATATYPE)   = 2048
        %    sizeof(MRIMAGEDATATYPE)  = 2048


        hdrLength.header_size      = 145908;

        hdrLength.PIXEL_HDR_LEN = 124;
        hdrLength.SUITE_HDR_LEN = 116;

        hdrLength.RAW_HDR_LEN      = 2048;
        hdrLength.PER_PASS_TBL_LEN = 16384;
        hdrLength.UNLOCK_TBL_LEN   = 16384;

        hdrLength.DATA_ACQ_TBL_LEN = 98304;
        hdrLength.NEX_TBL_LEN      = 2052;
        hdrLength.NEX_ABORT_LEN    = 2052;

        hdrLength.TOOLS_DATA_LEN   = 2048;
        
        hdrLength.PRESCAN_HDR_LEN  = 1500;    % This did not exist until 14

        hdrLength.EXAM_HDR_LEN     = 1040;
        hdrLength.SERIES_HDR_LEN   = 2048;
        hdrLength.IMAGE_HDR_LEN    = 2048;
        

    case 11
 	    hdrLength.header_size      = 66072;    
        hdrLength.DATA_ACQ_TBL_LEN = hdrLength.DATA_ACQ_TBL_LEN + 4096;  %  45056 = 2*20480 + 4096
	    hdrLength.SERIES_HDR_LEN   = hdrLength.SERIES_HDR_LEN   + 512;
        
    case 10
 	    hdrLength.header_size = 66072;    
        hdrLength.DATA_ACQ_TBL_LEN =  hdrLength.DATA_ACQ_TBL_LEN + 4096;
	    hdrLength.SERIES_HDR_LEN   =  hdrLength.SERIES_HDR_LEN   + 512;
	    hdrLength.TOOLS_DATA_LEN   =  hdrLength.TOOLS_DATA_LEN   - 4;

    case 9
 	    hdrLength.header_size = 61464;    
    
    case 8
        hdrLength.header_size = 60464;
	    hdrLength.SERIES_HDR_LEN = 1028;
	    hdrLength.IMAGE_HDR_LEN = 1044;
  
    otherwise
    	hdrLength.header_size = 39984;
	    hdrLength.DATA_ACQ_TBL_LEN=20480;
	    hdrLength.SERIES_HDR_LEN = 1028;
	    hdrLength.IMAGE_HDR_LEN = 1044;
end

% /*
% ---------
% 11.x sizes  (pfile11 corresponding to 12.0 release)
% ---------
% hdr_rec     =   2048
% per_pass    =   4096   4096
% lock_raw    =   4096
% acq_tab     =  45056  45056
% nex_tab     =   2052   2052
% nex_abort   =   2052   2052
% tool        =   2048   2048
% exam        =   1040   1040
% series      =   1536   2048
% image       =   1536   1536
% ---------------------
% TOTAL       =  65560  66072

hdrLength.header_size_total = hdrLength.EXAM_HDR_LEN + ...
                              hdrLength.SERIES_HDR_LEN + ...
                              hdrLength.IMAGE_HDR_LEN + ...
                              hdrLength.PRESCAN_HDR_LEN + ...
                              hdrLength.DATA_ACQ_TBL_LEN + ...
                              hdrLength.RAW_HDR_LEN + ...
                              hdrLength.PER_PASS_TBL_LEN + ...
                              hdrLength.UNLOCK_TBL_LEN + ...
                              hdrLength.NEX_TBL_LEN + ...
                              hdrLength.NEX_ABORT_LEN + ...
                              hdrLength.TOOLS_DATA_LEN;
 
%
% Calculate Header Offsets
%

hdrOffset.RAW_HDR_OFFSET       = 0;
hdrOffset.PER_PASS_TBL_OFFSET  = hdrOffset.RAW_HDR_OFFSET      + hdrLength.RAW_HDR_LEN;
hdrOffset.UNLOCK_TBL_OFFSET    = hdrOffset.PER_PASS_TBL_OFFSET + hdrLength.PER_PASS_TBL_LEN; 

hdrOffset.DATA_ACQ_TBL_OFFSET  = hdrOffset.UNLOCK_TBL_OFFSET   + hdrLength.UNLOCK_TBL_LEN;
hdrOffset.NEX_TBL_OFFSET       = hdrOffset.DATA_ACQ_TBL_OFFSET + hdrLength.DATA_ACQ_TBL_LEN;
hdrOffset.NEX_ABORT_OFFSET     = hdrOffset.NEX_TBL_OFFSET      + hdrLength.NEX_TBL_LEN;

hdrOffset.TOOLS_DATA_OFFSET    = hdrOffset.NEX_ABORT_OFFSET    + hdrLength.NEX_ABORT_LEN;
        
hdrOffset.PRESCAN_HDR_OFFSET   = hdrOffset.TOOLS_DATA_OFFSET   + hdrLength.TOOLS_DATA_LEN;

hdrOffset.EXAM_HDR_OFFSET      = hdrOffset.PRESCAN_HDR_OFFSET  + hdrLength.PRESCAN_HDR_LEN;
hdrOffset.SERIES_HDR_OFFSET    = hdrOffset.EXAM_HDR_OFFSET     + hdrLength.EXAM_HDR_LEN;
hdrOffset.IMAGE_HDR_OFFSET     = hdrOffset.SERIES_HDR_OFFSET   + hdrLength.SERIES_HDR_LEN;


                          
return;
