function [mat] = wfu_spm_mt(xdim,ydim,iop,ipp,SliceThickness,PixelSpacing, spmOffset)
%------------------------------------------------------
%Computes the SPM M matrix
%xdim = number of columns (ie 64)
%ydim = number of rows (ie 64)
%iop = image orientation patient (DICOM 0020,0037)
%ipp = image position patient   (DICOM 0020, 0032)
%For GE raw data use ge2dcm to compute ipp and iop
%------------------------------------------------------
%hdr=spm_dicom_headers(P);
%nc = hdr{1}.Columns;
%nr = hdr{1}.Rows;
%iop=hdr{1}.ImageOrientationPatient;
%ipp=hdr{i}.ImagePositionPatient;
%SliceThickness=hdr{1}.SliceThickness;
%PixelSpacing=hdr{1}.PixelSpacing;
%------------------------------------------------------


if nargin < 7  || isempty(spmOffset)
    spmOffset = 1;
end

if abs(spmOffset) ~= 1
   error('spmOffset must be equal to 1 or -1'); 
end

% Image dimensions
%------------------------------------------------------
nc = xdim;
nr = ydim;
dim    = [nc nr];

% Orientation information
%------------------------------------------------------
% Axial Analyze voxel co-ordinate system:
% x increases     right to left
% y increases posterior to anterior
% z increases  inferior to superior

% DICOM patient co-ordinate system:
% x increases     right to left
% y increases  anterior to posterior
% z increases  inferior to superior

% T&T co-ordinate system:
% x increases      left to right
% y increases posterior to anterior
% z increases  inferior to superior

analyze_to_dicom = [diag([1 -1 1]) [0 (dim(2)+ spmOffset) 0]'; 0 0 0 1]*[eye(4,3) [-1 -1 -1 1]'];
orient           = reshape(iop,[3 2]);
orient(:,3)      = null(orient');
if det(orient)<0, orient(:,3) = -orient(:,3); end;
z = SliceThickness;
vox              = [PixelSpacing z];
pos              = ipp';
dicom_to_patient = [orient*diag(vox) pos ; 0 0 0 1];
patient_to_tal   = diag([-1 -1 1 1]);
mat              = patient_to_tal*dicom_to_patient*analyze_to_dicom;
return;


