function [ outputIndex, nOutputIndex ] = wfu_create_index_array( inputIndex, maxIndex, startingOffset )
%-----------------------------------------------------
% Function: wfu_create_index_array
%
% Purpose:  Creates an index array from a string containing a valid index
%           expression. If a numeric array is entered for the input index
%           then that input index is returned unchanged.
%           
%
% Arguments:   inputIndex - A numeric array or a string containing a valid
%                           index array.
%
%              maxIndex - Maximum value of index 
%
%              startingOffset - A starting offset to the index array. This
%              allows one to create an index array
%           
% Returns:      
%                        
%              outputIndex - Is equal to input index when input index is a numeric array or equal to 1:maxIndex when
%                            inputIndex is an allowed string
%
% Example of Usage:
%
%        >> a = wfu_create_index_array(':',4)
%
%           a =
%
%               1     2     3     4
%
%        >> a = wfu_create_index_array(1:5,4)
%
%           a =
%
%               1     2     3     4     5
%           
%-----------------------------------------------------

if nargin < 3 | isempty(startingOffset)
    startingOffset = 0;
end

%
% If input index is empty return empty output index
%
if isempty(inputIndex)
    outputIndex = [];
    return;
end

%
%
%

if( ischar(inputIndex)  )        
        outputIndex = (startingOffset+1):maxIndex;
        outputIndex = eval(sprintf('outputIndex(%s)', inputIndex));            
else
        outputIndex = inputIndex+startingOffset;
end

if max(outputIndex) > maxIndex
    error('*** WARNING: Index requested exceeds maximum allowable index (%d>%d)', max(outputIndex), maxIndex);
end

if( size(outputIndex,1) ~= 1)
   outputIndex = outputIndex.'; 
end


nOutputIndex = length(outputIndex);