function isEpiflex = wfu_is_epi(fileNames)
%
% PURPOSE: - Checks to see if the file name is acquired with EPI
%
% INPUTS:
%
%
% OUTPUTS: 
%
%
% EXAMPLE:
%
%
%==========================================================================
% C H A N G E   L O G
%
%--------------------------------------------------------------------------

if ~iscell(fileNames)
    fileNames = {fileNames};
end

%
% Loop over all file names
%

nFileNames = length(fileNames);

isEpi      = zeros(1,nFileNames);
isEpiflex  = zeros(1,nFileNames);

for ii=1:nFileNames
        
    try
        hdr = wfu_get_mri_info(fileNames{ii});

        isEpi(ii)     = (regexp( hdr.PulseSeqName(1:min(3,length(hdr.PulseSeqName))),'epi') == 1) || ...
                        (regexp( hdr.InternalPulseSeqName(1:min(3,length(hdr.PulseSeqName)),'epi') == 1));

        isEpiflex(ii) = wfu_is_epiflex(fileNames{ii});
                    
        isEpi(ii)     = isEpi(ii) && ~ isEpiflex(ii);
        
    catch
        isEpi(ii) = false;
    end
end

