function paradigmCode = wfu_get_epiflex_fmri_paradigm(fileNames)
%-----------------------------------------------------
% Function: wfu_get_epiflex_fmri_paradigm(fileName)
%
% Purpose:  Returns the fMRI paradigm code as specified in the EPIFLEX P
%           file header. 
%
% Inputs: 
%
%     fileNames   =  A file name or list of file names of P-file to read.
%
% Outputs:
%
%     paradigmCode  = EPIFLEX P file with paradigm number
%                     EPIFLEX P file without paradigm number = 0
%                     P file from non EPIFLEX PSD = NaN
%
%==========================================================================
% Change Log
%------------------------------------------------------------------------

if ~iscell(fileNames)
   fileNames = {fileNames}; 
end

nFileNames = length(fileNames);

paradigmCode = zeros(1,nFileNames);

for ii=1:nFileNames 

    if wfu_is_epiflex_pfile(fileNames{ii})

        hdr = wfu_get_epiflex_header(fileNames{ii});

        if isfield(hdr,'fMRIParadigmNumber')
            paradigmCode(ii) = hdr.fMRIParadigmNumber;
        else
            paradigmCode(ii) = 0;
        end
    else
            paradigmCode(ii) = nan;        
    end
end
