function varargout = wfu_get_epiflex_info(fileNames )
%
% PURPOSE: - Read the P file hdr and return a structure containing information about the P file.
%
% INPUTS:
%
%
% OUTPUTS: 
%
%
% EXAMPLE:
%

%
%   EPIFLEX_V14_07_00_00 Definitions for opuser25 - opuser48. 
%   This values are stored in DICOM fields Private_0043_1038
%  

%  

%
%
%==========================================================================
% C H A N G E   L O G
%
%--------------------------------------------------------------------------


if ~iscell(fileNames)
    fileNames = {fileNames};
end

isEpiflex = wfu_is_epiflex(fileNames);

if all(~isEpiflex)
    for ii=1:length(isEpiflex)
        disp(sprintf('%s', fileNames{ii}));
    end
    error('Files were not are not acquired with EPIFLEX');
end

%
% Loop over all file names
%

nFileNames = length(fileNames);

epiflexInfoCell  = cell(1,nFileNames);
rawInfoCell      = cell(1,nFileNames);


for ii=1:nFileNames

    [getInfo dicomInfo ]= wfu_get_mri_info(fileNames{ii});
    
    rawInfoCell{ii}     = dicomInfo;
    epiflexInfoCell{ii} = getInfo;

    epiflexInfoCell{ii}.nPassReps = epiflexInfoCell{ii}.NumberOfVolumes;

    if strcmpi( epiflexInfoCell{ii}.FileFormat, 'DICOM')
    
    opuser        = zeros([1 49]);

    opuser(  1 ) = dicomInfo.Private_0019_10a7;
    opuser(  2 ) = dicomInfo.Private_0019_10a8;
    opuser(  3 ) = dicomInfo.Private_0019_10a9;
    opuser(  4 ) = dicomInfo.Private_0019_10aa;
    opuser(  5 ) = dicomInfo.Private_0019_10ab;

    opuser(  6 ) = dicomInfo.Private_0019_10ac;
    opuser(  7 ) = dicomInfo.Private_0019_10ad;
    opuser(  8 ) = dicomInfo.Private_0019_10ae;
    opuser(  9 ) = dicomInfo.Private_0019_10af;
    opuser( 10 ) = dicomInfo.Private_0019_10b0;

    opuser( 11 ) = dicomInfo.Private_0019_10b1;
    opuser( 12 ) = dicomInfo.Private_0019_10b2;
    opuser( 13 ) = dicomInfo.Private_0019_10b3;
    opuser( 14 ) = dicomInfo.Private_0019_10b4;
    opuser( 15 ) = dicomInfo.Private_0019_10b5;

    opuser( 16 ) = dicomInfo.Private_0019_10b6;
    opuser( 17 ) = dicomInfo.Private_0019_10b7;
    opuser( 18 ) = dicomInfo.Private_0019_10b8;
    opuser( 19 ) = dicomInfo.Private_0019_10b9;
    opuser( 20 ) = dicomInfo.Private_0019_10ba;

    opuser( 21 ) = dicomInfo.Private_0019_10bb;
    opuser( 22 ) = dicomInfo.Private_0019_10bc;
    opuser( 23 ) = dicomInfo.Private_0019_10bd;
    opuser( 24 ) = dicomInfo.Private_0019_10df;
    opuser( 25 ) = dicomInfo.Private_0019_10e0;  % opuser(24) on scanner

    opuser(26:49) = dicomInfo.Private_0043_1038;
        
    %************************************
    % Get EPIFLEX specific information
    %************************************

        
    if isempty(strfind(lower(epiflexInfoCell{ii}.PulseSeqName), 'epiflex'))

        epiflexInfoCell{ii}.EpiflexVersion       = 0;
        epiflexInfoCell{ii}.EpiTmin              = 0;
        epiflexInfoCell{ii}.EpiTminTotal         = 0;

        epiflexInfoCell{ii}.AcquisitionCode      = 0;
        epiflexInfoCell{ii}.AcquisitionName      = '';
        epiflexInfoCell{ii}.fMRIParadigmNumber   = 0;
        epiflexInfoCell{ii}.Trajectory           = 1;  % 1= Standard EPI, 2= DS-EPI
        epiflexInfoCell{ii}.Propeller.On         = 0;
        
    else
        
        
%%        %%      /*****************************************************/
        %       /*** Common opuser CVs independent of epiflex type ***/
        %       /*****************************************************/
        %       opuser25 = epiflex_version;
        %       opuser26 = tmin;
        %       opuser27 = epiflex_ref_total;
        %       opuser28 = 1000*grad_warp + 100*rhcoilno   + epiflex_imdisplay;
        %       opuser29 = order_routine;  /* 0=Interleave(TYPNCAT); 6=Sequential(TYPNORMORDER) */
%%      %
        
        epiflexVersion = opuser(26);
        
        if epiflexVersion >= 140700
            epiflexInfoCell{ii}.EpiflexVersion = epiflexVersion;
        else
            if strcmpi(epiflexInfoCell{ii}.InternalPulseSeqName,'epiflex_v')
                epiflexVersion                     = wfu_remove_chars(epiflexInfoCell{ii}.InternalPulseSeqName(10:end),'_');
                epiflexInfoCell{ii}.EpiflexVersion = str2double(epiflexVersion);
            else
                epiflexInfoCell{ii}.EpiflexVersion = str2double(epiflexInfoCell{ii}.SoftwareVersion(1:2))*10000;
            end
        end
        
        % Temporoary fix for difference in pulse sequence code between
        % before 14000 and after 14000
        
        
        if epiflexVersion >= 140700
            
            epiflexInfoCell{ii}.EpiTmin              = floor(opuser(27)); % Assume opuser(25) = rhuser25
            epiflexInfoCell{ii}.EpiTminTotal         = epiflexInfoCell{ii}.EpiTmin + ...
                                                       10000*(opuser(27) - epiflexInfoCell{ii}.EpiTmin );

            % Assume opuser(25) = rhuser25
            epiflexInfoCell{ii}.TotalRefScan         = floor(opuser(28));
            epiflexInfoCell{ii}.sliceOrder           = wfu_get_digits(opuser(28).*10, 1);     % 6 - sequential

            decImdisplay                             = opuser(29);

            if (decImdisplay - floor(decImdisplay)) == 0.1
                epiflexInfoCell{ii}.saveInterStep     = 1;
            end

            epiflexInfoCell{ii}.imdisplay           = wfu_get_digits(floor(decImdisplay), [1 2]);

            if decImdisplay > 9999
                epiflexInfoCell{ii}.gradWarp        = 1;
            else
                epiflexInfoCell{ii}.gradWarp        = 0;
            end
        else
            
            epiflexInfoCell{ii}.EpiTmin              = 60; % Assume 60ms hdr.raw.user(2);  % rhuser1
            epiflexInfoCell{ii}.EpiTminTotal         = 60; % Assume 60ms hdr.raw.user(3);  % rhuser2
            
        end
        
        %
        % DDA information
        %

        TR      = epiflexInfoCell{ii}.RepetitionTime;
        
        if strcmpi(epiflexInfoCell{ii}.PulseSeqName,'epiflex_dda')
            ddaTime = 0;
        else
            ddaTime = 20000;
        end
 
         ddaAcquire0 = -1;
         ddaAcquire1 = -1;
         ddaAcquire2 = -1;

         epiflexInfoCell{ii}.ddaAcquire0 = 0;            
         epiflexInfoCell{ii}.ddaAcquire0 = ddaAcquire0;  
         epiflexInfoCell{ii}.ddaAcquire1 = ddaAcquire1;  
         epiflexInfoCell{ii}.ddaAcquire2 = ddaAcquire2;  

         %
         if epiflexVersion >= 140700
             
            epiflexInfoCell{ii}.ddaN                = opuser(28);
            epiflexInfoCell{ii}.AcquisitionCode     = opuser(1); % CV User 4,  for some strange reason sometimes
                                                       % the Acquisition code is located in dicomInfo.Private_0019_10a7;
            
         else
             
             if epiflexInfoCell{ii}.NumberOfVolumes > 16
                 epiflexInfoCell{ii}.ddaN     = floor(ddaTime/TR);
             else
                 epiflexInfoCell{ii}.ddaN     = 0;
             end
             
             epiflexInfoCell{ii}.AcquisitionCode    = dicomInfo.Private_0019_10aa;
         end
         
         epiflexInfoCell{ii}.ddaN0    = 0;  % rhuser12
         epiflexInfoCell{ii}.ddaN1    = 0;  % rhuser14


         epiflexInfoCell{ii}.ddaAcquire =  (epiflexInfoCell{ii}.ddaAcquire0 || ...
                                            epiflexInfoCell{ii}.ddaAcquire1 || ...
                                            epiflexInfoCell{ii}.ddaAcquire2);
% 



        epiflexInfoCell{ii}.fMRIParadigmNumber   = opuser(25); % dicomInfo.Private_0019_10e0;

%         epiflexInfoCell{ii}.Trajectory           = mod(max([ 1 hdr.raw.user(17)]),10); %1=Normal, 2=COMB
% 
        epiflexInfoCell{ii}.Propeller.On            = 0;
          
          
 
         %
         % Get specific information according to EPIFLEX type
         %
 
         switch epiflexInfoCell{ii}.AcquisitionCode
 
             case 1  % Normal
   
                 epiflexInfoCell{ii}.AcquisitionName = 'fmri';

                 epiflexInfoCell{ii}.NumberOfVolumes =  max([1 (epiflexInfoCell{ii}.NumberOfVolumesPrescribed -  epiflexInfoCell{ii}.ddaN)]);

%                 if ddaAcquire1 == true
%                     epiflexInfoCell{ii}.ddaRefVolumes     = 1; 
%                     epiflexInfoCell{ii}.ddaNoiseVolumes   = []; 
%                 end
                 
                 
             case 2  % DC CSI
 
                 epiflexInfoCell{ii}.AcquisitionName = 'csi';
% 
%                 if ddaAcquire1 == true
%                     epiflexInfoCell{ii}.ddaRefVolumes    = 1; 
%                     epiflexInfoCell{ii}.ddaNoiseVolumes  = []; 
%                 end
% 
             case 3  % DC PSF
% 
                 epiflexInfoCell{ii}.AcquisitionName = 'psf';
% 
%                 if ddaAcquire1 == true
%                     epiflexInfoCell{ii}.ddaRefVolumes    = 1; 
%                     epiflexInfoCell{ii}.ddaNoiseVolumes  = []; 
%                 end
%                 
%                 epiflexInfoCell{ii}.psf.fov         = hdr.raw.user30;
%                 epiflexInfoCell{ii}.psf.order       = hdr.raw.user31;
%                 epiflexInfoCell{ii}.psf.maxphases   = hdr.raw.user32;
%                 epiflexInfoCell{ii}.psf.psdgrdwait  = hdr.raw.user33;
%                 epiflexInfoCell{ii}.psf.nphases     = hdr.raw.user34;
%                 epiflexInfoCell{ii}.psf.psfFOV      = hdr.raw.user35;
%                 epiflexInfoCell{ii}.psf.nOffset     = hdr.raw.user36;
%                 epiflexInfoCell{ii}.psf.nEndRef     = hdr.raw.user37;
% 
             case 4  % PASL
%                 

%%           /*****************************************************/
%            /*** PASL                                          ***/
%            /*****************************************************/
% 
%           opuser30 = exist(oppasl_order);
%           opuser31 = exist(oppasl_ti1);
%           opuser32 = exist(oppasl_ti1s);
%           opuser33 = exist(oppasl_ti2);
% 
%           opuser34 = 100*n_rf_ipsat2 + n_rf_ipsat1;
%           opuser35 = slpos_ipsat;
%           opuser36 = slthick_ipsat;
% 
%           opuser37 = slthick_rf0_label;
%           opuser38 = slthick_rf0_control;
% 
% 
%           /*  opuser42 is set in epiRTfile.e for recon 
%               opuser42 = type_lpsat;
% 	        */
% 
%           opuser39 = (n_rf_lpsat1+n_rf_lpsat2);
%           opuser40 = slthick_lpsat;
%           opuser41 = slpos_lpsat;
% 
%           opuser43 = (n_rf_outpsat1+n_rf_outpsat2);
% 
%           opuser46  =   1 * (dbg_pasl_rf0==PSD_ON);            		    /* rf0                         */
%           opuser46 +=   2 * (dbg_pasl_rf_ipsat1==PSD_ON);      		    /* rf pre ipsat                */
%           opuser46 +=   4 * (dbg_pasl_rf_ipsat2==PSD_ON);      		    /* rf post ipsat               */
%           opuser46 +=   8 * (dbg_pasl_rf_lpsat==PSD_ON);       		    /* rf lpsat                    */
%           opuser46 +=  16 * (dbg_pasl_rf_outpsat==PSD_ON);                  /* rf outpsat                  */
%           opuser46 +=  32 * (exist(oppasl_fatsat)==PSD_ON);     	    /* rf pasl_fatsat              */
%           opuser46 +=  64 * (epiflex_rf1==EPIFLEX_RF1_SPSP_14400_US);       /* Spatial Spectral RF1 pulses */
%           opuser46 += 128 * (epiflex_rf1==EPIFLEX_RF1_EPI_SPEC_800_US);     /* Spatial Spectral RF1 pulses */
%           
%           if(  (pasl_on == PSD_ON) && (pasl_diffusion == PSD_ON) ) {
% 
%             opuser47 = exist(oppasl_diffusion_bdir);
%             opuser48 = pasl_diffusion_b;
% 
%           } else {
% 
%             opuser47 = 0;
%             opuser48 = 0;
%           }
% 

            epiflexInfoCell{ii}.AcquisitionName = 'pasl';
                 
            
            if epiflexInfoCell{ii}.NumberOfVolumes > 16
                epiflexInfoCell{ii}.ddaN     = 10;
            else
                epiflexInfoCell{ii}.ddaN     = 0;
            end

            epiflexInfoCell{ii}.ddaN0    = 4;  % rhuser12
            epiflexInfoCell{ii}.ddaN1    = 6;  % rhuser14
            epiflexInfoCell{ii}.ddaN2    = 0;  % rhuser14
             
            epiflexInfoCell{ii}.NumberOfVolumes =  max([1 (epiflexInfoCell{ii}.NumberOfVolumesPrescribed -  epiflexInfoCell{ii}.ddaN)]);

%                 
%                 
%                 refVolumes   = [];
%                 noiseVolumes = [];
%                 
%                 epiflexInfoCell{ii}.ddaRefVolumes     = refVolumes;
%                 epiflexInfoCell{ii}.ddaNoiseVolumes   = noiseVolumes; 
%                   
%                 if epiflexInfoCell{ii}.EpiflexVersion >= 110212
%                     
%                     if ddaAcquire0 == true
%                         refVolumes   = [refVolumes 1]; 
%                         noiseVolumes = [noiseVolumes 2:(ddaN0-1)]; 
%                     end
%                     
%                     if ddaAcquire1 == true
%                         refVolumes  = [refVolumes ddaN0+2];  % First volume normal, 2nd volume ref 
%                     end
%                     
%                     if (ddaAcquire1 == true) || (ddaAcquire1 == true)
%                         epiflexInfoCell{ii}.ddaRefVolumes     = refVolumes;
%                         epiflexInfoCell{ii}.ddaNoiseVolumes   = noiseVolumes; 
%                     end
%                 end            
%                 
%                 paslTag = hdr.raw.user30;
%                 
%                 switch(paslTag)
%                     case 1 
%                         epiflexInfoCell{ii}.pasl.Tag = 'picore';
%                     case 2 
%                         epiflexInfoCell{ii}.pasl.Tag = 'fair';
%                     case 3 
%                         epiflexInfoCell{ii}.pasl.Tag = 'picore3';
%                     case 4 
%                         epiflexInfoCell{ii}.pasl.Tag = 'fair3';
%                     otherwise
%                         epiflexInfoCell{ii}.pasl.Tag = 'unknown';                    
%                 end
% 
% 
%                 epiflexInfoCell{ii}.pasl.Sequence      = hdr.raw.user31;
% 
%                 % QUIPSS_ORDER (0=Label/Control/Sat, 1=Control/Sat/Label, 2=Sat/Control/Label).
%                 epiflexInfoCell{ii}.pasl.Order         = hdr.raw.user32;
%                 epiflexInfoCell{ii}.pasl.acquireM0     = hdr.raw.user28;
% 
%                 epiflexInfoCell{ii}.pasl.TI1           = hdr.raw.user33;
%                 epiflexInfoCell{ii}.pasl.TI1s          = hdr.raw.user34;
%                 epiflexInfoCell{ii}.pasl.TI2           = hdr.raw.user35;
% 
%                 epiflexInfoCell{ii}.pasl.imageFOV      = hdr.raw.user27;
% 
%                 epiflexInfoCell{ii}.pasl.IpSat.Type     = hdr.raw.user36;
%                 epiflexInfoCell{ii}.pasl.IpSat.SlThick  = hdr.raw.user37;
%                 epiflexInfoCell{ii}.pasl.IpSat.nPre     = hdr.raw.user38;
%                 epiflexInfoCell{ii}.pasl.IpSat.nPost    = hdr.raw.user39;
%                 epiflexInfoCell{ii}.pasl.IpSat.rfOnPre  = hdr.raw.user46 & 2;
%                 epiflexInfoCell{ii}.pasl.IpSat.rfOnPost = hdr.raw.user46 & 4;
% 
%                 epiflexInfoCell{ii}.pasl.Inv.Type      = hdr.raw.user40;
%                 epiflexInfoCell{ii}.pasl.Inv.SlThick   = hdr.raw.user41;
%                 epiflexInfoCell{ii}.pasl.Inv.rfOn       = hdr.raw.user46 & 1;
% 
%                 epiflexInfoCell{ii}.pasl.LpSat.Type    = hdr.raw.user42;
%                 epiflexInfoCell{ii}.pasl.LpSat.SlThick = hdr.raw.user43;
%                 epiflexInfoCell{ii}.pasl.LpSat.n       = hdr.raw.user44;
%                 epiflexInfoCell{ii}.pasl.LpSat.Gap     = hdr.raw.user45;
%                 epiflexInfoCell{ii}.pasl.LpSat.rfOn    = hdr.raw.user46 & 8;
% 
%                 epiflexInfoCell{ii}.pasl.diffB   = hdr.raw.user48;
%                 epiflexInfoCell{ii}.pasl.diffDir = hdr.raw.user47;
%                 
%                 epiflexInfoCell{ii}.pasl.OutpSat.rfOn  = hdr.raw.user46 & 16;
%                 epiflexInfoCell{ii}.pasl.FatSat.rfOn   = hdr.raw.user46 & 32;
%                 epiflexInfoCell{ii}.pasl.ssrf1.rfOn    = hdr.raw.user46 & 64;
%%           

             case 5  % T1 Map
            
%%           /****************************************************/
%            /*** T1 Map                                       ***/
%            /****************************************************/
%
%       /*** IR RF0 - Inversion Pulse ***/
%
%           opuser30 = dbg_pasl_rf0;     /* IR RF0 Off/On */
%           opuser31 = type_ir_rf0;      /* IR RF0 Type */
%           opuser32 = slthick_ir_rf0;   /* IR RF0 Slice Thickness */
%           opuser33 = slpos_ir_rf0;     /* IR RF0 Slice Position  */
%
%       /*** TI Acquisition Information  ***/
%
%           opuser34 = 1;                          /* M0 Position                         */
%           opuser35 = pasl_t1map_ti_min;          /* Minimum TI Time                     */
%           opuser36 = pasl_t1map_ti_max;          /* Maximum TI Time                     */
%
%           opuser37 = pasl_t1map_method;          /* 1= TI Increment, 2=Slice Shift      */
%           opuser38 = oppasl_t1map_ti_mode;       /* TI Spacing  1=Equal, 2=Log10        */
%           opuser39 = oppasl_t1map_inv_type;      /* Inversion Type  1=Global,   2=Slab  */
%           opuser40 = oppasl_t1map_tr_mode;       /* TR Mode 1=Constant, 2=Variable      */
%
%           opuser41 = pasl_t1map_nti;             /* Number of TI samples                */
%           opuser43 = epiflex_slice_shift;        /* Slice Shifting 0=Off, 1=On          */
%           opuser44 = epiflex_slice_shift_offset; /* Slice Shift Offset                  */
%
%           opuser45 = epiflex_fphase_mod_total;
%           opuser46 = epiflex_fphase_mod_pasl_ti;
%           opuser47 = epiflex_fphase_mod_slice_shift;
%
%
                 
            epiflexInfoCell{ii}.AcquisitionName =   't1map';
            epiflexInfoCell{ii}.NumberOfVolumes =  max([1 (epiflexInfoCell{ii}.NumberOfVolumesPrescribed -  epiflexInfoCell{ii}.ddaN)]);

            if ddaAcquire0 == true

                epiflexInfoCell{ii}.ddaRefVolumes   = opuser(35);

            else
                epiflexInfoCell{ii}.ddaRefVolumes       = [];
                epiflexInfoCell{ii}.ddaNoiseVolumes     = [];
            end

            epiflexInfoCell{ii}.t1map.Mode                    = opuser(39);  % 1=Equal, 2=Logarithmic
            epiflexInfoCell{ii}.t1map.sliceShift              = opuser(44);  % Slice shift
            epiflexInfoCell{ii}.t1map.sliceShiftOffset        = opuser(45);  % Slice shift offset

            epiflexInfoCell{ii}.t1map.TImin                   = opuser(36);  % Default set in EPIFLEX code
            epiflexInfoCell{ii}.t1map.TImax                   = opuser(37);  % Maximum TI time
            epiflexInfoCell{ii}.t1map.nTI                     = opuser(42);

            epiflexInfoCell{ii}.t1map.TI                      = zeros(1,epiflexInfoCell{ii}.t1map.nTI);

            epiflexInfoCell{ii}.t1map.AcquisitionTimePerSlice = 60; % Assume 60milliseconds
            epiflexInfoCell{ii}.t1map.M0Position              = opuser(35);


            %************************************************************************************
            % Calculate raw TI time
            %************************************************************************************

                          
            nTI = epiflexInfoCell{ii}.t1map.nTI;

                % ti       = zeros(1,nTI);
                % ti(1)   = epiflexInfoCell{ii}.t1map.TImin;  % milliseconds
                % ti(nTI) = epiflexInfoCell{ii}.t1map.TImax;  % milliseconds

                if epiflexInfoCell{ii}.t1map.Mode == 1  % TI distributed equally

                    % tiIncrement    = (i(nTI) - ti(1))/(nTI-1);
                    % ti(2:nTI-1)    = ti(1) + ((2:(nTI-1))-1)*tiIncrement;

                    ti = linspace(epiflexInfoCell{ii}.t1map.TImin, ...
                                  epiflexInfoCell{ii}.t1map.TImax, nTI);
                                        
                else % TI logarithmically

                    ti = logspace(log10(epiflexInfoCell{ii}.t1map.TImin), ...
                                  log10(epiflexInfoCell{ii}.t1map.TImax), nTI);

                end

                for jj=1:nTI
                      ti(jj)  = ti(jj)*1000;
                      ti(jj)  = ti(jj) + mod(4-mod(ti(jj), 4),4);  %RUP_GRD GRAD_UPDATE_TIME = 4;
                      ti(jj)  = ti(jj)/1000;
                end

                epiflexInfoCell{ii}.t1map.TI = ti;

             otherwise
 
                 epiflexInfoCell{ii}.AcquisitionName = 'Unknown';
 
         end

     end % DICOM FORMAT
     end 
end

%
% Modify parameters that are affected by the EPIFLEX Type
%
 


%
% Write Output
%

if nargout > 0
    if nFileNames == 1
        varargout{1} = epiflexInfoCell{1};
    else
        varargout{1} = epiflexInfoCell;
    end
end

if nargout > 1
      if nFileNames == 1
        varargout{2} = rawInfoCell{1};
    else
        varargout{2} = rawInfoCell;
      end
end

