function isEpiflex = wfu_is_epiflex(fileNames)
%
% PURPOSE: - Checks to see if the file name is acquired with EPIFLEX.
%
% INPUTS:
%
%
% OUTPUTS: 
%
%
% EXAMPLE:
%
%
%==========================================================================
% C H A N G E   L O G
%
%--------------------------------------------------------------------------

if ~iscell(fileNames)
    fileNames = {fileNames};
end

%
% Loop over all file names
%

nFileNames = length(fileNames);

isEpiflex  = zeros(1,nFileNames);

for ii=1:nFileNames
        
    try
        hdr = wfu_get_mri_info(fileNames{ii});

        isEpiflex(ii) = ( ~isempty(regexp( hdr.PulseSeqName,'epiflex')) ) || ...
                        ( ~isempty(regexp( hdr.InternalPulseSeqName,'epiflex')));
        
    catch
        errorInfo = lasterror;
        fprintf('Error received: %s\n',errorInfo.message);
        isEpiflex(ii) = false;
    end
end

