function isEpiflex = wfu_is_epiflex_ifile(fileNames);
%
% PURPOSE: - Checks to see if the file name is an epiflex P file.dr and return a structure containing information about the P file.
%
% INPUTS:
%
%
% OUTPUTS: 
%
%
% EXAMPLE:
%
%
%==========================================================================
% C H A N G E   L O G
%
%--------------------------------------------------------------------------

if ~iscell(fileNames)
    fileNames = {fileNames};
end

%
% Loop over all file names
%

nFileNames = length(fileNames);

isEpiflex  = zeros(1,nFileNames);

for ii=1:nFileNames
        
    try
        hdr = wfu_get_mri_info(fileNames{ii});

        [directory, psdName, extension] = fileparts( hdr.PulseSeqName );

        % Convert all / to \ on PC
        if ispc
            psdName = strrep(psdName,'/','\');
        end
    
        isEpiflex(ii) = ~isempty(regexp( psdName,'epiflex'));
        
    catch
        isEpiflex(ii) = false;
    end
end

