function isPFile = wfu_is_p_file(fileNames);
%
% PURPOSE: - Checks to see if the file name is an epiflex P file.dr and return a structure containing information about the P file.
%
% INPUTS:
%
%
% OUTPUTS: 
%
%
% EXAMPLE:
%
%
%==========================================================================
% C H A N G E   L O G
%
%--------------------------------------------------------------------------

if ~iscell(fileNames)
    fileNames = {fileNames};
end

%
% Loop over all file names
%

nFileNames = length(fileNames);

isPFile  = zeros(1,nFileNames);

for ii=1:nFileNames
        
    try
        revision = wfu_get_p_header_revision(fileNames{ii});

        if isnan(revision)
              isPFile(ii) = false;
        else
        isPFile(ii) = true;
        end
        
    catch
        isPFile(ii) = false;
    end
end

