function [fnames, dnames] = wfu_find_mat_files(directory, recurseFlag, options)
%-----------------------------------------------------
% Function: wfu_find_mat_files(directory, displayFlag, recurseFlag)
%
% Purpose:  Find Matlab mat files
%
% Inputs:   directory   - Directory to search (default current directory)           
%           recurseFlag - Search subdirectories (default false)
% 
% Options : options.displayFiles - Display a list of P files that were found (default true)
%           options.displayDir   - Display a list of directories where the P 
%                                  files were found (default false)
%
% Returns:  List of Mat file names with absolute path
%
%==========================================================================
% Change Log
%------------------------------------------------------------------------

%
% Set options
%
defaultOptions = struct('displayFiles',true, 'displayDirectories', false);

if nargin < 3	options = [];
end

options = wfu_set_function_options(options,defaultOptions);


if nargin < 1 || isempty(directory)
    directory = cd;
end

if nargin < 2 ||  isempty(recurseFlag)
    recurseFlag = false;
end

%
%
%

[fnames, dnames] = wfu_find_files('.*.mat$', directory, recurseFlag, options); 
