function [fnames, dnames] = wfu_find_pfiles(directory, recurseDepth, options)
%-----------------------------------------------------
% Function: wfu_find_pfiles(directory, recurseFlag, options )
%
% Purpose:  Find pfiles with MoJoe naming convention
%
% Inputs:   directory    - Directory to search (default current directory)           
%           recurseDepth - Search subdirectories (default 0). If integer then only
%                          searches to that subdirectory depth. If logical
%                          true searches until maximum recursion depth. 
% 
% Options : options.displayFiles   -  Display a list of P files that were found (default true)
%           options.displayDir      - Display a list of directories where the P 
%                                     files were found (default false)
%           options.displayProgress - Displays current directory being
%                                     searched (default false)
%
% Returns:  List of P files names with absolute path
%
%==========================================================================
% Change Log
%------------------------------------------------------------------------

%
% Set options
%

defaultOptions = struct('displayFiles',true, 'displayDirectories', false, ...
                 'displayProgress', false);

if nargin < 3	
    options = [];
end

options = wfu_set_function_options(options,defaultOptions);


if nargin < 1 || isempty(directory)
    directory = cd;
end

if nargin < 2 ||  isempty(recurseDepth)
    recurseDepth = 0;
end

[ fnames,  dnames ] = wfu_find_files('P\d{5}(.7|)$', directory, recurseDepth, options);


