function PO = wfu_prepend_to_filename(PI,pre,multiflag)

if nargin > 2
    switch multiflag
        
        case 'list' 
            PI = cellstr(PI);
            for i = 1:length(PI) 
                [pth,nm,xt,vr]  = fileparts(deblank(PI{i}));
                PO{i}           = fullfile(pth,[pre nm xt vr]);
            end
            PO = PO'; 
            
        case 'cell'
            for i = 1:length(PI) 
                for x = 1:length(PI{i})
                    [pth,nm,xt,vr]  = fileparts(deblank(PI{i}{x}));
                    PO{i}{x}        = fullfile(pth,[pre nm xt vr]);
                    PO{i}           = PO{i}';
                end
            end
    end
else
    
    [pth,nm,xt,vr] = fileparts(deblank(PI));
    PO             = fullfile(pth,[pre nm xt vr]);
end

return