%
% PURPOSE: - Saves variables in the current workspace to a Matlab mat file in
%            Matlab version 6 format regardless of the current version of
%            Matlab.
%
%
% CATEGORY: Utility
%
% INPUTS:
% 
%    fileName - File name of the mat file.
%
%    varargin - List of strings containing the names of the variables to be saved.
%               See Matlab's save function for more information
%
% OUTPUTS: 
%
%    None
%
% EXAMPLE:
%
%   >> a = 2;
%   >> wfu_save_mat('test.mat','a');
%
%
function wfu_save_mat(matFileName,varargin) 

    if iscell(matFileName)
        matFileName = char(matFileName{1});
    end

    % Determine the version of Matlab running. This is necessary so
    % everything can be read in by Matlab 6 even if Matlab 7 was used to
    % reconstruct the data

    v = ver('Matlab');
    versionMatlab = str2num(v.Version(1));
    
    tmp       = sprintf(' ''%s'',', varargin{:});  % Create a single string with the variables to save.
    variables = tmp(1:end-1); % Remove last comma
        
        
    if exist(matFileName) ~= 2
 
        % Always write in Matlab 6 Mat format
        if versionMatlab > 6
            evalin('caller', sprintf('save(''%s'', %s, ''-v6'');', matFileName, variables));
        else
            evalin('caller', sprintf('save(''%s'', %s);', matFileName, variables));            
        end
    else
        
        % Always write in Matlab 6 Mat format
        if versionMatlab > 6
            evalin('caller', sprintf('save(''%s'', %s, ''-v6'', ''-append'');', matFileName, variables));
        else
            evalin('caller', sprintf('save(''%s'', %s, ''-append'');', matFileName, variables));            
        end
    end
