function wfu_show_structure(structCell, tableFigureTitle, nColumnWidthMax )
% wfu_show_p_header  Displays fields in the header of a GE P-file in
%                      a uitable inside a Matlab figure.
%                   The info displayed can be saved to an Excel file.
%
% If no filename argument is supplied, a file browser pops up to
%    allow selection of a file.
%
% CAHamilton  2/4/05
% --------------------------------------------------------------------
wfu_show_structure_version = 1.002;
% Version History
% 1.000   03/04/2005   Initial coding.
% 1.001   03/15/2005   Cleanup for inclusion in WFU_geToolbox
% 1.002   03/18/2005   Added ability to display nested structures and arrays.

% TODO:
%   - add resize handling
%   - make it stay open so user can select additional Pfiles?

nStruct    = length(structCell);

if nargin < 2 | isempty(tableFigureTitle)
   tableFigureTitle = sprintf('wfu_show_structure %5.3f',...
                             wfu_show_structure_version);
end

if nargin < 3 | isempty(nColumnWidthMax)
   nColumnWidthMax = floor(1000 / (nStruct + 1));
end

if ~iscell(structCell)
   structCell = {structCell}; 
end


showColumnLabels = cell(1,nStruct+1);
editableColumn   = cell(1,nStruct+1);

showColumnLabels{1} = 'Name';
editableColumn{1}   =  false;

for ii=2:nStruct
    showColumnLabels{ii} = 'Value';
    editableColumn{ii}   = false;
end

showNames    = fieldnames(structCell{1});
nShowNames   = length(showNames);
showInfoCell = showNames;


% Create Table into structure
for ii=1:nStruct
    showCell     = struct2cell(structCell{ii});
    showInfoCell = [showInfoCell showCell];
end

% Clean Up Table

nColumnWidth = 0;

%Save message state of this pesky message
messageState = warning('query', 'MATLAB:nonIntegerTruncatedInConversionToChar');
warning('off', 'MATLAB:nonIntegerTruncatedInConversionToChar');

for ii=1:nStruct
   for jj=1:nShowNames
       if( isstruct(showInfoCell{jj,ii+1}))
           showInfoCell{jj,ii+1} = 'Structure';
       end
       
       if( prod(size(showInfoCell{jj,ii+1})) ~= 1)
           showInfoCell{jj,ii+1} = mat2str( showInfoCell{jj,ii+1} );
       end

       tmp = floor(length(deblank(strtok(char(floor(showNames{jj})),char(0)))));
       nColumnWidth = max( [ nColumnWidth, tmp ]);

       tmp = floor(length(deblank(strtok(char(floor(showInfoCell{jj,ii+1})),char(0)))));
       nColumnWidth = max( [ nColumnWidth, tmp ]);
   end
end

%Restore message state of this pesky message
warning(messageState);

nColumnWidth = min( [5*nColumnWidth, nColumnWidthMax]);  % Multiply by 4.5 to scale from 
                                                           % characters to pixels per character
nRowHeight   = 20;

xStart = 30;
yStart = 30;
xMax   = 800;
yMax   = 600;

figurePosition = [ xStart, yStart,  min([xMax  2*xStart + nColumnWidth*(nStruct+1)])+60, ...
                  min([yMax yStart + nRowHeight*(nShowNames+1)])];
              
tablePosition  = [ xStart/2 yStart/2  min([ xMax xStart + nColumnWidth*(nStruct+1)+25]), ...
                   min([yMax nRowHeight*(nShowNames+1)])];
% create the figure
ifig = figure('Name',tableFigureTitle,...
                  'Units','pixels',...
                  'Position',figurePosition,...
                  'NumberTitle','off',...
                  'Resize','on',...
                  'ToolBar','none',...
                  'MenuBar','none',...
                  'DockControls','off');
 
 % create menubar
 mbar = uimenu('Label','File');
 uimenu(mbar,'Label','Save',...
             'Callback',{@savecallback,showInfoCell});
 
% create table
uitable('Parent',ifig,...
        'Data',showInfoCell,...
        'ColumnWidth',nColumnWidth + 10,...
        'NumRows', 80, ...
        'ColumnNames', showColumnLabels(1:(nStruct+1)),...               % 'Editable', editableColumn(1:(nStruct+1)), 
        'Position', tablePosition);

     
%============================================================
function savecallback(obj,ev,info)

[fileName, pathName, filterIndex] = ...
    uiputfile({'*.xls', 'Excel file'}, ...
                'Save header information to Excel file');

% need to handle user pressing Cancel
if isempty(pathName)
    return;
end

[stat,msg]=xlswrite(fullfile(pathName,fileName),info);
if stat == 0
    disp(msg.message);
end

%=======================================================================



