function dhs_coreg(flistname, setmat, run)
%____________________________________________________________________________
%
% function dhs_coreg(flistname, setmat, run)
%
% run SPM5 coregistration interactively for each directory in the input list
%
% flistname -- file name containing list of directories
% setmat    -- create the output mat? (0 = no, 1 = yes)
% run       -- run the mat? (0 = no, 1 = yes)   
%
% KLP
% 5/16/06
%____________________________________________________________________________
%

if nargin < 1
    flistname='subjects.txt';
end
if nargin < 2
    setmat = 1;
end
if nargin < 3
    run = 1;
end
%
% load the template and insert the specified files for each directory
%
path = fileparts(which('dhs_coreg'));
load(fullfile(path, 'coreg_template.mat'));
coregdir = cellstr(wfu_bpm_read_flist(flistname));
n = length(coregdir);
gospm(5);
if setmat
    disp('generating jobman coreg.mat file');
    for i = 2:n
        jobs{1}.spatial{i} = jobs{1}.spatial{1};
    end
    for i = 1:n
        disp(['coregdir = ', coregdir{i}]);
        f1 = deblank(ls(fullfile(coregdir{i}, 'analyze/*efgre3d.dicom')));
        f2 = deblank(ls(fullfile(coregdir{i}, 'analyze/*720*.dicom')));
        f2n = strrep(f2, 'analyze', 'nifti/dti');
        jobs{1}.spatial{i}.coreg{1}.estimate.ref{1} = strrep(f1, '.dicom', '.img');
        jobs{1}.spatial{i}.coreg{1}.estimate.source{1} = strrep(f2n, '.dicom', '_ECC_S0.img');
        jobs{1}.spatial{i}.coreg{1}.estimate.other{1}  = strrep(f2n, '.dicom', '_ECC_FA.img');
    end
    save coreg.mat jobs
    if run
        disp('running coreg');
        spm_jobman('run', fullfile(pwd, 'coreg.mat'));
    end
end
