function jfk_coreg(coregdir)
% 
% function jfk_coreg(coregdir)
%
% For each directory within coregdir, set the entries for the coreg
% jobs struct and run the resulting job. 
%

% KLP
% 05/10/06
%

%
% switch to SPM5
% 
gospm(5);
%
% Read the coregistration template created from a single instance of 
% the coreg job set up interactively.
%
path = fileparts(which('jfk_coreg'));
load(fullfile(path, 'coreg_template.mat'));
%
% For each directory, set the jobs struct fields:
%     ref, source, other
%
n = length(coregdir);
for i = 1:n
    disp(['coregdir = ', coregdir{i}]);
    f1 = deblank(ls(fullfile(coregdir{i}, 'analyze/*efgre3d.dicom')));
    f2 = deblank(ls(fullfile(coregdir{i}, 'analyze/*720*.dicom')));
    f2n = strrep(f2, 'analyze', 'nifti/dti');
    jobs{1}.spatial{i}.coreg{1}.estimate.ref{1} = strrep(f1, '.dicom', '.img');
    jobs{1}.spatial{i}.coreg{1}.estimate.source{1} = strrep(f2n, '.dicom', '_ECC_S0.img');
    jobs{1}.spatial{i}.coreg{1}.estimate.other{1}  = strrep(f2n, '.dicom', '_ECC_FA.img');
%
% Create a new directory for the coreg *.ps file.  In SPM5, there 
% does not seem to be a way to control the coreg output *.ps name 
% unless making an extra copy, as in:
%     spm_print('fname.ps');
%
    psdir = fullfile(coregdir{i}, 'analyze', 'coreg');
    if exist(psdir, 'dir')
        [status, result] = unix(['rm -rf ' psdir]);
        if status
            error(['could not remove old dir: ' psdir]);
        end
    end
    [status, result] = unix(['mkdir -p ' psdir]);
    if status
        error(['could not create new dir: ' psdir]);
    end
%
% Save the current directory and change to the new directory.
% Run the coreg job, reset previous current directory.
%
    here = pwd;
    cd(psdir);
    spm_jobman('run', jobs);
    pwd
    ls -lst *.ps
    cd(here);
end
