function jfk_param(paramdir)
% 
% function jfk_param(paramdir)
%
% For each directory within paramdir:
%    copy nifti/dti/*.FA.img to analyze/*.FA.img
%    copy nifti/dti/*.FA.hdr to analyze/*.FA.hdr
%    run wfu_param_report from analyze subdirectory
%

%
% switch to SPM5
% 
gospm(5);
%
% For each directory, call wfu_param_report
%
n = length(paramdir);
for i = 1:n
    disp(['paramdir = ', paramdir{i}]);
    f1 = deblank(ls(fullfile(paramdir{i}, 'analyze/*720*.dicom')));
    f1n = strrep(f1, 'analyze', 'nifti/dti');
    img = strrep(f1n, '.dicom', '_ECC_FA.img');
    dest = fullfile(paramdir{i}, 'analyze');
    cmd = ['yes | cp -p ' img ' ' dest]; 
    [status, result] = unix(cmd);
    if status
        error(['could not copy ' img '  to  ' dest]);
    end
    hdr = strrep(img, '.img', '.hdr');
    cmd = ['yes | cp -p ' hdr ' ' dest]
    [status, result] = unix(cmd);
    if status
        error(['could not copy ' hdr '  to  ' dest]);
    end
    img2 = strrep(img, 'nifti/dti', 'analyze')
    csv = fullfile(dest, 'param_report.csv');
    wfu_report_param(img2, [], [.6 .6 .6], csv);
end
