function wfu_grid
%_______________________________________________________________
%
% function wfu_grid
%
%     call GUI to set arguments for function wfu_grid_run
%_______________________________________________________________
% JAM, KLP 4/26/06
% 

titlebar_text = 'WFU  Grid';
color1 = [.6, .6, .6];
color2 = [0 .4 .4];
version = 'Version 1.1';
version_color = [0, 0, 0];
label_color = [1, 1, 1];
%
% create FIGURE based on screen size
%
screen = get(0, 'ScreenSize');
xwidth = screen(3)/2.25;
yheight = screen(4)/2.25;
B = [100, screen(4) - yheight - 100, xwidth, yheight];
f = figure('Position', B, ...
	'Name', titlebar_text, ...
	'Color', color1,...
	'HandleVisibility', 'on',...
	'IntegerHandle', 'off',...
	'Renderer', 'painters',...
	'NumberTitle', 'off',...
	'MenuBar', 'none', ...
	'Toolbar', 'none' ... 
	);
%
% create PANEL to hold buttons
%
edge = B(4)/15;
panelw = B(3) - edge * 2;
panelh = B(4) - edge * 2;
p = uicontrol(f, 'Style', 'frame', ...
    'BackgroundColor', color2, ...
    'Position', [edge, edge, panelw, panelh], ...
    'Parent', f);
%
% create version label
%
version_pos = [edge, panelh + edge *1.25 , edge * 3, edge/2];
versionLabel = uicontrol(f, 'Style', 'text', ...
    'ForegroundColor', version_color, ...
    'BackgroundColor', color1, ...
    'HorizontalAlignment', 'l', ...
    'Position', version_pos, ...
    'String', version, ...
    'Parent', f);
nbutton = 3;
buttonmargin = edge * 1.5;
buttonw = (panelw - buttonmargin*(nbutton+1))/nbutton;
buttonh = edge * .75;
buttonx1 = edge + buttonmargin;
buttonx2 = buttonx1 + buttonw + buttonmargin;
buttonx3 = buttonx2 + buttonw + buttonmargin;
%buttony = edge + buttonh/2;
buttony = edge + buttonh;
%
% create option label
%
w = buttonw;
h = edge/2;
x = edge  + buttonmargin;
y = panelh;
optiony = y;
labeloption = uicontrol(f, 'Style', 'text',...
        'HorizontalAlignment', 'l',...
        'Position',[x y w h],...
        'ForegroundColor', label_color, ...
         'BackgroundColor', color2, ...
        'String', 'Option',...
        'Parent', f);
%
% create option check boxes 
%
y = y - h * 1.5;
x = edge  + buttonmargin;
h = buttonh;
w = ((buttonw * 2 + buttonmargin)/3) * .9;
option1 = uicontrol(f, 'Style', 'checkbox', ...
        'HorizontalAlignment', 'l',...
        'Position', [x y w h], ...
        'String', 'File list', ...
        'Value', 1, ...
        'Parent', f, ...
	'Tag', 'optionflist', ...
        'Callback', @option1Callback);
x = x + (buttonw * 2 + buttonmargin)/3;
option2 = uicontrol(f, 'Style', 'checkbox', ...
        'HorizontalAlignment', 'l',...
        'Position', [x y w h], ...
        'String', 'Image', ...
        'Value', 0, ...
        'Parent', f, ...
	'Tag', 'optionimage', ...
        'Callback', @option2Callback);
x = x + (buttonw * 2 + buttonmargin)/3;
option3 = uicontrol(f, 'Style', 'checkbox', ...
        'HorizontalAlignment', 'l',...
        'Position', [x y w h], ...
        'String', 'Loop', ...
        'Value', 0, ...
        'Parent', f, ...
	'Tag', 'optionloop', ...
        'Callback', @option3Callback);
%
% create file name label
%
w = buttonw;
h = edge/2;
x = edge  + buttonmargin;
y = y - h * 2.5;
labelitem = uicontrol(f, 'Style', 'text',...
        'HorizontalAlignment', 'l',...
        'Position',[x y w h],...
        'ForegroundColor', label_color, ...
        'BackgroundColor', color2, ...
        'String', 'File list',...
	'Parent', f, ...
       'Tag', 'labelitem');
%
% create nloop label in the same location
%
labelnloop = uicontrol(f, 'Style', 'text',...
        'HorizontalAlignment', 'l',...
        'Position',[x y w h],...
        'ForegroundColor', label_color, ...
        'BackgroundColor', color2, ...
        'String', '# of loops',...
	'Parent', f, ...
        'Visible', 'off', ...
	'Tag', 'labelnloop');
%
% create flist text edit 
%
y = y - h * 1.5;
h = buttonh;
w = buttonw * 2 + buttonmargin;
%here = fileparts(which('wfu_grid'));
here = pwd;
editflist = uicontrol(f, 'Style', 'edit', ...
        'HorizontalAlignment', 'l',...
        'Position', [x y w h], ...
	'String', fullfile(here, 'fmri1.flist'), ...
        'Parent', f, ...
	'Tag', 'editflist', ...
        'Callback', @editflistCallback);
%
% create image fname edit in the same location for switching between,
% depending on the option 
%
editimage = uicontrol(f, 'Style', 'edit', ...
        'HorizontalAlignment', 'l',...
        'Position', [x y w h], ...
	'String', fullfile(here, 'mod1/grp1/zmap1.img'), ...
        'Parent', f, ...
	'Visible', 'off', ...
	'Tag', 'editimage', ...
        'Callback', @editimageCallback);
%
% create nloop text edit in the same location but small width
%
editnloop = uicontrol(f, 'Style', 'edit', ...
        'HorizontalAlignment', 'l',...
        'Position', [x y buttonw h], ...
        'String', '1', ...
        'Parent', f, ...
        'Visible', 'off', ...
        'Tag', 'editnloop', ...
        'Callback', @editnloopCallback);
%
% create browse button
%
buttonbrowseitem = uicontrol(f, 'Style', 'pushbutton',...
        'Position', [buttonx3 y buttonw buttonh],...
        'String', 'Browse',...
        'Parent', f,...
        'Tag', 'buttonbrowseitem', ...
        'Callback', @buttonbrowseitemCallback);
%
% create partition label
%
w = buttonw;
h = edge/2;
x = edge  + buttonmargin;
y = y - h * 2.5;
partitiony = y;
labelpartition = uicontrol(f, 'Style', 'text',...
        'HorizontalAlignment', 'l',...
        'Position',[x y w h],...
        'ForegroundColor', label_color, ...
         'BackgroundColor', color2, ...
        'String', 'Partition',...
        'Parent', f);
%
% create partition check boxes 
%
y = y - h * 1.5;
x = edge  + buttonmargin;
h = buttonh;
w = ((buttonw * 2 + buttonmargin)/3) * .9;
partition1 = uicontrol(f, 'Style', 'checkbox', ...
        'HorizontalAlignment', 'l',...
        'Position', [x y w h], ...
        'String', 'Point', ...
        'Value', 1, ...
        'Parent', f, ...
	'Tag', 'partitionpoint', ...
        'Callback', @partition1Callback);
x = x + (buttonw * 2 + buttonmargin)/3;
partition2 = uicontrol(f, 'Style', 'checkbox', ...
        'HorizontalAlignment', 'l',...
        'Position', [x y w h], ...
        'String', 'Slice', ...
        'Value', 0, ...
        'Parent', f, ...
	'Tag', 'partitionslice', ...
        'Callback', @partition2Callback);
x = x + (buttonw * 2 + buttonmargin)/3;
partition3 = uicontrol(f, 'Style', 'checkbox', ...
        'HorizontalAlignment', 'l',...
        'Position', [x y w h], ...
        'String', 'Vector', ...
        'Value', 0, ...
        'Parent', f, ...
	'Tag', 'partitionvector', ...
        'Callback', @partition3Callback);
%
% create vector length label
%
w = buttonw;
h = edge/2;
x = buttonx3;
y = partitiony;
labelvectorlength = uicontrol(f, 'Style', 'text',...
        'HorizontalAlignment', 'l',...
        'Position',[x y w h],...
        'ForegroundColor', label_color, ...
        'BackgroundColor', color2, ...
        'String', 'Vector length', ...
	'Visible', 'off', ...
        'Parent', f, ...
        'Tag', 'labelvectorlength');
%
% create vector size text edit 
%
y = y - h * 1.5;
h = buttonh;
editvectorlength = uicontrol(f, 'Style', 'edit', ...
        'HorizontalAlignment', 'l',...
        'Position', [x y w h], ...
        'String', '1', ...
	'Visible', 'off', ...
        'Parent', f, ...
        'Tag', 'editvectorlength', ...
        'Callback', @editvectorlengthCallback);
%
% create command label
%
w = buttonw;
h = edge/2;
x = edge  + buttonmargin;
y = y - h * 2.5;
labelcommand = uicontrol(f, 'Style', 'text',...
        'HorizontalAlignment', 'l',...
        'Position',[x y w h],...
        'ForegroundColor', label_color, ...
         'BackgroundColor', color2, ...
        'String', 'Commands',...
        'Parent', f);
%
% create command text edit 
%
y = y - h * 1.5;
h = buttonh;
%w = buttonw * 3 + buttonmargin * 2;
w = buttonw * 2 + buttonmargin;
editcommand1 = uicontrol(f, 'Style', 'edit', ...
        'HorizontalAlignment', 'l',...
        'Position', [x y w h], ...
        'String', 'grid_flist(mask)', ...
        'Parent', f, ...
        'Tag', 'editcommand1', ...
        'Callback', @editcommand1Callback);
%
% create command options list 
%
h = buttonh;
w = buttonw;
x = buttonx3;
popupmenucommand = uicontrol(f, 'Style', 'popupmenu', ...
        'HorizontalAlignment', 'l',...
        'Position', [x y w h], ...
        'String', 'User defined|JFK coreg|JFK param|sniptest', ...
        'Min', 1, ...
        'Max', 2, ...
        'Value', 1, ...
        'Parent', f, ...
        'Tag', 'popupmenucommand', ...
        'Callback', @popupmenucommandCallback);
%
% create log dir label
%
w = buttonw;
h = edge/2;
x = edge  + buttonmargin;
y = y - h * 2.5;
labellogdir = uicontrol(f, 'Style', 'text',...
        'HorizontalAlignment', 'l',...
        'Position',[x y w h],...
        'ForegroundColor', label_color, ...
         'BackgroundColor', color2, ...
        'String', 'Log directory',...
        'Parent', f);
%
% create log dir text edit 
%
y = y - h * 1.5;
h = buttonh;
w = buttonw * 2 + buttonmargin;
editlogdir = uicontrol(f, 'Style', 'edit', ...
        'HorizontalAlignment', 'l',...
        'Position', [x y w h], ...
        'String', pwd, ...
        'Parent', f, ...
        'Tag', 'editlogdir', ...
        'Callback', @editlogdirCallback);
%
% create browse button
%
buttonbrowselog = uicontrol(f, 'Style', 'pushbutton',...
        'Position', [buttonx3 y buttonw buttonh],...
        'String', 'Browse',...
        'Parent', f,...
        'Callback', @buttonbrowselogdirCallback);
%
% create BUTTONS 1-3
%
buttonhelp = uicontrol(f, 'Style', 'pushbutton', ...
        'Position', [buttonx1, buttony, buttonw, buttonh], ...
        'String', 'Help', ...
        'Parent', f, ...
        'Callback', @buttonhelpCallback);

buttonrun = uicontrol(f, 'Style', 'pushbutton', ...
        'Position', [buttonx2, buttony, buttonw, buttonh], ...
        'String', 'Run', ...
        'Parent', f, ...
        'Callback', @buttonrunCallback);
buttonexit = uicontrol(f, 'Style', 'pushbutton', ...
        'Position', [buttonx3, buttony, buttonw, buttonh], ...
        'String', 'Exit', ...
        'Parent', f, ...
        'Callback', @buttonexitCallback);
%
% set FONT for buttons
%
if isunix
    uihandles = findall(f, 'Type', 'uicontrol');
    set(uihandles, 'FontName', 'Helvetica', 'FontSize', 10);
 end
%
% CALLBACKS
%
function option1Callback(src, evt)
set(findobj('Tag', 'optionflist'), 'Value', 1)
set(findobj('Tag', 'optionimage'), 'Value', 0)
set(findobj('Tag', 'optionloop'),  'Value', 0)
set(findobj('Tag', 'labelitem'),   'String', 'File list');
set(findobj('Tag', 'labelitem'),         'Visible', 'on');
set(findobj('Tag', 'buttonbrowseitem'),  'Visible', 'on');
set(findobj('Tag', 'labelnloop'),        'Visible', 'off'); 
set(findobj('Tag', 'editflist'),         'Visible', 'on'); 
set(findobj('Tag', 'editimage'),         'Visible', 'off'); 
set(findobj('Tag', 'editnloop'),         'Visible', 'off'); 
%
function option2Callback(src, evt)
set(findobj('Tag', 'optionflist'), 'Value', 0)
set(findobj('Tag', 'optionimage'), 'Value' ,1)
set(findobj('Tag', 'optionloop'),  'Value', 0)
set(findobj('Tag', 'labelitem'),   'String', 'Image');
set(findobj('Tag', 'labelitem'),         'Visible', 'on');
set(findobj('Tag', 'buttonbrowseitem'),  'Visible', 'on');
set(findobj('Tag', 'labelnloop'),        'Visible', 'off'); 
set(findobj('Tag', 'editflist'),         'Visible', 'off'); 
set(findobj('Tag', 'editimage'),         'Visible', 'on'); 
set(findobj('Tag', 'editnloop'),         'Visible', 'off'); 
 %
function option3Callback(src, evt)
set(findobj('Tag', 'optionflist'), 'Value', 0)
set(findobj('Tag', 'optionimage'), 'Value', 0)
set(findobj('Tag', 'optionloop'),  'Value', 1)
set(findobj('Tag', 'labelitem'),         'Visible', 'off');
set(findobj('Tag', 'buttonbrowseitem'),  'Visible', 'off');
set(findobj('Tag', 'labelnloop'),        'Visible', 'on'); 
set(findobj('Tag', 'editflist'),         'Visible', 'off'); 
set(findobj('Tag', 'editimage'),         'Visible', 'off'); 
set(findobj('Tag', 'editnloop'),         'Visible', 'on'); 
%
function partition1Callback(src, evt)
set(findobj('Tag', 'partitionpoint'),    'Value', 1)
set(findobj('Tag', 'partitionslice'),    'Value', 0)
set(findobj('Tag', 'partitionvector'),   'Value', 0)
set(findobj('Tag', 'labelvectorlength'), 'Visible', 'off');
set(findobj('Tag', 'editvectorlength'),  'Visible', 'off');
%
function partition2Callback(src, evt)
set(findobj('Tag', 'partitionpoint'),    'Value', 0)
set(findobj('Tag', 'partitionslice'),    'Value', 1)
set(findobj('Tag', 'partitionvector'),   'Value', 0)
set(findobj('Tag', 'labelvectorlength'), 'Visible', 'off');
set(findobj('Tag', 'editvectorlength'),  'Visible', 'off');
%
function partition3Callback(src, evt)
set(findobj('Tag', 'partitionpoint'),    'Value', 0)
set(findobj('Tag', 'partitionslice'),    'Value', 0)
set(findobj('Tag', 'partitionvector'),   'Value', 1)
set(findobj('Tag', 'labelvectorlength'), 'Visible', 'on');
set(findobj('Tag', 'editvectorlength'),  'Visible', 'on');
%
function buttonbrowseitemCallback(src, evt)
filter = '*';
if get(findobj('Tag', 'optionflist'), 'Value')
    title = 'Select file list';
    DefaultName = get(findobj('Tag', 'editflist'), 'String');
elseif get(findobj('Tag', 'optionimage'), 'Value')
    title = 'Select image';
    DefaultName = get(findobj('Tag', 'editimage'), 'String');
else
   return;
end
%
% - - - - - - - - - - - - - - - - - - - - - - - - - - - 
% uigetfile command
% MATLAB7 (Windows) does not accept location arguments;
% MATLAB7 (Windows, UNIX) will not accept location
%         arguments it DefaultName is empty
% - - - - - - - - - - - - - - - - - - - - - - - - - - -
%
xylocation = pixlocation;
if strncmp(version, '6', 1)
    if exist(DefaultName, 'file')
        [FileName, PathName, FilterIndex] = uigetfile(filter, title, DefaultName, xylocation(1), xylocation(2));
    else
        [FileName, PathName, FilterIndex] = uigetfile(filter, title, '', xylocation(1), xylocation(2));
    end
else
    if exist(DefaultName, 'file') && isunix
        [FileName, PathName, FilterIndex] = uigetfile(filter, title, DefaultName, 'Location', xylocation);
    else
        [FileName, PathName, FilterIndex] = uigetfile(filter, title);
    end
end
if FileName ~=0 
    if get(findobj('Tag', 'optionflist'), 'Value')
        set(findobj('Tag', 'editflist'), 'String', fullfile(PathName, FileName));
        drawnow;
        file_names = cellstr(wfu_bpm_read_flist(fullfile(PathName, FileName)))
        disp(sprintf('flist contains %d file names\n', length(file_names)));
    elseif get(findobj('Tag', 'optionimage'), 'Value')
        set(findobj('Tag', 'editimage'), 'String', fullfile(PathName, FileName));
        drawnow;
        v = spm_vol(fullfile(PathName,FileName));
        if isfield(v, 'dim') & length(v.dim) >= 3 & v.dim(3) >= 1
	  disp(sprintf('image volume has dimensions (%d,%d,%d)\n', v.dim(1), v.dim(2), v.dim(3)));
        end
    end
    drawnow;
end     
%
function buttonbrowselogdirCallback(src, evt)
DefaultName = get(findobj('Tag', 'editlogdir'), 'String');
PathName = uigetdir(DefaultName, 'Select GRID log location');
if PathName ~= 0 & exist(PathName, 'dir')
    set(findobj('Tag', 'editlogdir'), 'String', PathName);
end
%
function editflistCallback(src, evt)
FileName = get(src, 'String')
if exist(FileName, 'file')  
    file_names = cellstr(wfu_bpm_read_flist(FileName))
    disp(sprintf('flist contains %d file names\n', length(file_names)));
else
    uiwait(msgbox(['File name (' FileName ') does not exist!'], 'GRID WARNING', 'modal'));
end
%
function editimageCallback(src, evt)
FileName = get(src, 'String')
if exist(FileName, 'file')  
    v = spm_vol(FileName);
    if isfield(v, 'dim') & length(v.dim) >= 3 & v.dim(3) >= 1
        disp(sprintf('image volume has dimensions (%d,%d,%d)\n', v.dim(1), v.dim(2), v.dim(3)));
    else
        uiwait(msgbox(['File name (' FileName ') is not a 3d image!'], 'GRID WARNING', 'modal'));
    end
else
    uiwait(msgbox(['File name (' FileName ') does not exist!'], 'GRID WARNING', 'modal'));
end
%
function editnloopCallback(src, evt)
if isempty(str2num(get(findobj('Tag', 'editnloop'), 'String')))
    uiwait(msgbox('Bad value for # of loops!', 'GRID WARNING', 'modal'));
end
%
function editvectorlengthCallback(src, evt)
if isempty(str2num(get(findobj('Tag', 'editvectorlength'), 'String')))
    uiwait(msgbox('Bad value for vector length!', 'GRID WARNING', 'modal'));
end
%
function editlogdirCallback(src, evt)
PathName = get(src, 'String');
if isempty(PathName) || ~exist(PathName, 'dir')
    uiwait(msgbox('Bad log directory name!', 'GRID WARNING', 'modal'));
end
%
function popupmenucommandCallback(src, evt)
programNumber = get(src, 'Value');
if programNumber == 2
    set(findobj('Tag', 'editcommand1'), 'String', 'jfk_coreg(mask);');
elseif programNumber == 3
    set(findobj('Tag', 'editcommand1'), 'String', 'jfk_param(mask);');
elseif programNumber == 4
    set(findobj('Tag', 'editcommand1'), 'String', 'sniptest(mask);');
end
%
function editcommand1Callback(src, evt)
% disp('COMMAND 1');
function buttonhelpCallback(src, evt)
f = fullfile(pwd, 'README_wfu_grid.txt');
helptext = textread(f,'%s','delimiter','\n','whitespace','');
uiwait(msgbox(helptext, 'GRID HELP', 'modal'));
return;
%
function buttonrunCallback(src, evt)
if     get(findobj('Tag', 'optionflist'), 'Value')
    arg1 = 'flist';
    arg2 = get(findobj('Tag', 'editflist'), 'String');
elseif get(findobj('Tag', 'optionimage'), 'Value')
    arg1 = 'image';
    arg2 = get(findobj('Tag', 'editimage'), 'String');
elseif get(findobj('Tag', 'optionloop'),  'Value')
    arg1 = 'loop';
    arg2 =  get(findobj('Tag', 'editnloop'), 'String');
end
if     get(findobj('Tag', 'partitionpoint'), 'Value')
    arg3 = 'point';
elseif get(findobj('Tag', 'partitionslice'), 'Value')
    arg3 = 'slice';
elseif get(findobj('Tag', 'partitionvector'), 'Value')
    arg3 = 'vector';
end
arg4 = str2num(get(findobj('Tag', 'editvectorlength'), 'String'));
arg5 = get(findobj('Tag', 'editcommand1'), 'String');
arg6 = 3; % always set mask type to 3
arg7 = get(findobj('Tag', 'editlogdir'), 'String');
arg8 = 1; % always append the date and time to the "sge" output directory name
button = questdlg('Run now?', 'SGE Array Job', 'Yes', 'No', 'Yes');
drawnow;
if strcmp(arg1, 'image'), arg6 = 1; end;
if strcmp(button, 'Yes')
	arg1
	arg2
	arg3
	arg4
	arg5
	arg6
	arg7
	arg8
   wfu_grid_run(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8);
end

%
function buttonexitCallback(src, evt)
%button = questdlg('Exit now?', 'Exit Example Toolbox', 'Yes', 'No', 'Yes');
%if strcmp(button, 'Yes')
    disp('EXITING ...');
    closereq;
%else
%    disp('EXIT cancelled');
%end
%
% utility
%
function [uilocation, pixpos, screen] = pixlocation
%
% return the upper left hand corner GUI location in pixels
%
figunits = get(gcf, 'Units');
set(gcf, 'Units', 'pixels');
pixpos = get(gcf, 'Position');
set(gcf, 'Units', figunits);
screenunits = get(0, 'Units');
set(0, 'Units', 'pixels');
screen = get(0, 'ScreenSize');
set(0, 'Units', screenunits);
uilocation = [pixpos(1), screen(4) - pixpos(2) - pixpos(4)];
