function mask = wfu_grid_mask(option, item, inc, mtype, id)
%_______________________________________________________________
%
% function mask = wfu_grid_mask(option, item, inc, mtype, id)
%
%    generate a mask for flist, image, or loop
%
% mask   - returned list of vector indices, mask, or masked item
% option - one of {'flist', 'image', 'loop'}
% item   - item to be vectorized and masked
% inc    - increment (output vector length)
% mtype  - type of mask to return:
%            1 = list of vector indices
%            2 = entire list with 0 or 1 to indicate mask off, on
%            3 = masked item
%
% id     - optional input to specify task id number
%_______________________________________________________________
% JAM, KLP 4/26/06

% default mask is empty
mask = [];
%
% if id argument is specified, use it as instance number;
% if not, set instance number to SGE_TASK_ID if defined;
% otherwise, default the instance number to 1
%
if nargin > 4
    instanceno = id;
else
    instance = getenv('SGE_TASK_ID');
    if isempty(instance)
        instanceno = 1;
    else
        instanceno = str2num(instance);
    end
end
%
% determine the first and last vector indices
%
first = (instanceno - 1) * inc + 1;
last = first + inc - 1;
%
% set up the mask based on input option
%
switch option
    case {'flist'}
        if mtype == 1
	    mask = [first:last];
        elseif mtype == 2
            flistname = item;
            filenames = cellstr(wfu_bpm_read_flist(flistname));
            n = length(filenames);
	    mask = zeros(n, 1);
            mask(first:last) = 1;            
        elseif mtype == 3
            flistname = item;
            filenames = cellstr(wfu_bpm_read_flist(flistname));
            n = length(filenames);
            list = [];
            for i = first:last
                if i >= 1 && i <= n
                    list = strvcat(list, filenames{i});
                end
            end
            mask = cellstr(list);
        end
    case {'image'}
        imgname = item;
        v = spm_vol(imgname);
        vol = spm_read_vols(v);
        n = prod(size(vol));
        if mtype == 1
	    mask = [first:last];
	    pointer = find(vol(mask));
	    mask = mask(pointer);
        elseif mtype == 2
            mask = zeros(n, 1);
            mask(first:last) = 1;            
        elseif mtype == 3
	  mask = vol(first:last);    
        end
    case {'loop'}
        n = str2num(item);
	if last > n, last = n; end;
        if mtype == 1 || mtype == 3
	    mask = [first:last];
        elseif mtype == 2
	    mask = zeros(n, 1);
            mask(first:last) = 1;            
        end
end
