function wfu_autoprocessing(datadir)
%
% Determine if auto-processing should run.
%
% FORMAT wfu_autoprocessing(datadir)
%
% If any non-zero paradigm exists, output ProcessData flag as 1 (yes).
% Otherwise, output ProcessData flag as 0 (no).
%_______________________________________________________________________

%
% assume no non-zero paradigms
%
processData = 0;
%
% first, check the pfiles
%
pfiles = wfu_find_pfiles(datadir);
paradigms = wfu_get_epiflex_fmri_paradigm(pfiles);
if any(paradigms)
    processData = 1;
else
%
% if no paradigms found in pfile reference, check for *.info files
%
    infoFiles = wfu_find_files('\.info$', datadir);
    n = length(infoFiles);
    for i = 1:n
        
        infoText = wfu_read_info(infoFiles{i});
        if isfield(infoText, 'fMRIParadigmNumber')
            if any(infoText.fMRIParadigmNumber)
                processData = 1;
                break;
            end
       
            %%%%% if DTI, processData=1 so wfu_autoSPM5 will launch %%%%%
            if any(infoText.SeriesDescription)
                stop = find(infoText.SeriesDescription=='_');
                if ~isempty(stop) & (stop>1) 
                    sname = infoText.SeriesDescription(1:stop-1); 
                    if strcmp(sname,'DTI') | strcmp(sname,'TENSOR')
                        processData = 1;
                        break;
                    end
                end
            end
        end
    end
end
str = sprintf('ProcessData:\t%d', processData);
disp(str);
