function dircon = wfu_directory_configuration(displayDircon) 
% wfu_directory_configuration(displayDircon)
%
% displayDircon is bool for showing the directory configuration.
% default is true

if nargin < 1
	displayDircon = true;
end

dircon.rundir =         '/RUN';              % /subject_001/RUN(1,2,3)
dircon.normdir =        '/normalized';       % /subject_001/RUN1/normalized
dircon.spmdir =         '/spm_mat';          % /subject_001/RUN1/spm_mat

dircon.bchdir =         '/batch';            % /subject_001/batch
dircon.bchrundir =      '/RUN';              % /subject_001/batch/RUN(1,2,3)
dircon.anatdir =        '/anatomic';         % /subject_001/batch/anatomic #NEW# 
%NEW
dircon.dtidata =        '/dti';

dircon.vbmdir =         '/VBM';              % /subject_001/VBM
if strcmp(spm('Ver'), 'SPM5')
    dircon.anatdir =        'nifti';         % /subject_001/nifti
else
    dircon.anatdir =        'analyze';       % /subject_001/analyze
end

dircon.logdir =         '/log';              % /subject_001/log
dircon.logcompdir =     '/completion_log';    % /subject_001/log/completion_log

if (displayDircon)
	dircon
end

dircon.jpgNameR =       'spm_realign.jpg';   
dircon.jpgNameN_EPI =   'spm_EPI_normalise.jpg';
dircon.jpgNameN_T1 =    'spm_T1_normalise.jpg';
dircon.jpgNameN_OTHER = 'spm_normalise_newTemplate.jpg';

% realignment starts with /subject_001/RUN1/normalized/SUBJECT_001_RUN1.img
% snnr_.img files are in /subject_001/RUN1/normalized/


% **** need to change all strings, remove first backslash and use fullfile
