function [fullPath,found] = wfu_full_path(newPath)

%   returns an absolute directory path 
%   FORMAT fullPath = wfu_full_path(newPath) 
%   
%   fullPath    - absolute file path
%   found       - '1' if dir exists, '0' otherwise
%   newPath     - either absolute or relative file path
%
%   ##  v1.1, Aaron Baer, Wake Forest University    ##
%_________________________________________________________

fst = double(newPath(1)); %first character (as double)

if strcmp(newPath(1),filesep) | strcmp(newPath([2:3]),[':',filesep]) %(C:\) for PC
    fullPath = newPath;
elseif strcmp(newPath([1:2]),['.',filesep]) | strcmp(newPath([1:3]),['..',filesep])
    fullPath = fullfile(pwd,newPath);
elseif find(fst==double(filesep)|fst==45|(fst>=48&fst<=57)|(fst>=65&fst<=90)|fst==95|(fst>=97&fst<=122)|fst==126)
    fullPath = fullfile(pwd,newPath);
else
    error(sprintf( ...
        'Input argument (''%s'') has an invalid format.\nMust use: "/absdir/tmp", "reldir/tmp", "../dir", "C:/dir" etc.', ...
        newPath)); 
end

if exist(newPath,'dir')
    found = 1;
else
    warning(sprintf('Path (''%s'') does not exist\n',newPath)); 
    found = 0; 
end

return


    